// Copyright 1993, U.C.S.F. Computer Graphics Laboratory
// $Id: genmol.cc,v 2.11 94/03/04 14:03:08 gregc Exp $

#include <stdio.h>
#include <stdlib.h>
#include <GetOpt.h>
#include "mcd.h"
// The following is for mkdir and chdir prototypes
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#ifndef S_IRWXU
const int	S_IRWXU = 00700;	// read, write, execute: owner
const int	S_IRWXG = 00070;	// read, write, execute: group
const int	S_IRWXO = 00007;	// read, write, execute: other
#endif

enum { False, True };

static const char	*const OTFHOME_DIR = "/usr/local/otf";
static const char	*const MOLINCLUDE_DIR = "/include";
static const char	*const MOLLIBRARY = "/lib/libmol.a";
static const char	*const MAKEFILE = "Makefile";
static const char	*const SUFFIX = ".cc";

int		keep;
int		verbose;
const char	*output_name	= "Mol";
const char	*cflags		= "";
const char	*compiler	= "g++";
const char	*OTFHOME;

static void	write_makefile();
static int	compile_library();

int
main(int argc, char **argv)
{
	GetOpt	getopt(argc, argv, "kn:c:C:v");
	int	c;

	while ((c = getopt()) != EOF) switch (c) {
	case 'k': keep = True; break;
	case 'n': output_name = getopt.optarg; break;
	case 'c': cflags = getopt.optarg; break;
	case 'C': compiler = getopt.optarg; break;
	case 'v': verbose = True; break;
	default:
		goto usage;
	}

	if ((OTFHOME = getenv("OTFHOME")) == NULL)
		OTFHOME = OTFHOME_DIR;

	initialize_class_information();

	if (getopt.optind == argc)
		parse_mcd_file(NULL);
	else if (getopt.optind == argc - 1)
		parse_mcd_file(argv[argc - 1]);
	else {
usage:
		fprintf(stderr,
		"%s: [-d] [-f token] [-c cflags] [-C compiler] [input-file]\n",
			argv[0]);
		return 1;
	}

	if (mkdir(output_name, S_IRWXU|S_IRWXG|S_IRWXO) == -1
	&& errno != EEXIST) {
		fprintf(stderr, "unable to create %s subdirectory\n",
								output_name);
		return 2;
	}

	if (chdir(output_name) == -1) {
		fprintf(stderr, "unable to chdir to %s\n", output_name);
		return 2;
	}

	genClasses(output_name);
	write_mcd_header(output_name);
	write_mcd_body(output_name);

	if (keep)
		write_makefile();

	return compile_library();
}

static void
write_makefile()
{
	FILE	*f;
	Pix	i;
	Regex	compileSuffix("\\.\\(c\\|cc\\|C\\|cxx\\|m\\)$");

	if ((f = fopen(MAKEFILE, "w")) == NULL) {
		fprintf(stderr, "unable to open %s for writing\n", MAKEFILE);
		exit(1);
	}

	fprintf(f, "OTFHOME\t= %s\n", OTFHOME);
	fprintf(f, "CXX\t= %s\n", compiler);
	fprintf(f, ".SUFFIXES:\t%s\n", SUFFIX);
	fprintf(f, "%s.o:\n\t${CXX} -c -o $*.o ${CFLAGS} $*%s\n\n",
								SUFFIX, SUFFIX);
	fprintf(f, "CFLAGS\t= %s -I.. -I%s%s\n", cflags, OTFHOME, MOLINCLUDE_DIR);
	fprintf(f, "SRCS\t=");
	for (i = compileFiles.first(); i != 0; compileFiles.next(i))
		fprintf(f, " %s", compileFiles(i).chars());
	for (i = auxFiles.first(); i != 0; auxFiles.next(i)) {
		if (!auxFiles(i).contains(compileSuffix))
			continue;
		fprintf(f, " %s", auxFiles(i).chars());
	}
	fprintf(f, "\nOBJS\t= ${SRCS:%s=.o}\n", SUFFIX);
	fprintf(f, "LIB\t= lib%s.a\n", output_name);
	fprintf(f, "\n${LIB}: ${OBJS}\n"
		"\tar cr ${LIB} ${OBJS}\n"
		"\tranlib ${LIB}\n");
	fprintf(f, "\nclean:\n"
		"\trm -f ${OBJS}\n");
	fprintf(f, "\nclobber:\n"
		"\trm -f ${OBJS} ${LIB}\n");
	fprintf(f, "\ndepend:\n"
		"\tmv %s %s.save\n"
		"\tsed -n '1,/DE\\PEND/p' < Makefile.save > Makefile\n"
		"\t%s -MM ${CFLAGS} ${SRCS} | sed s\\|%s\\|\\$$\\{OTFHOME\\}\\| >> Makefile\n",
		MAKEFILE, MAKEFILE, compiler, OTFHOME);
	fprintf(f, "\n### DEPEND\n");

	if (verbose) {
		char	buf[BUFSIZ];

		rewind(f);
		while (fgets(buf, BUFSIZ, f) != NULL)
			fputs(buf, stdout);
	}
	if (fclose(f) == -1) {
		fprintf(stderr, "error while writing %s\n", MAKEFILE);
		exit(1);
	}
}

static int
compile_library()
{
	String	cmd;

	// symbolic link auxFiles into current directory
	for (Pix i = auxFiles.first(); i != 0; auxFiles.next(i)) {
		cmd = "rm -f ";
		int index = auxFiles(i).index("/", -1);
		if (index < 0)
			cmd += auxFiles(i);
		else
			cmd += auxFiles(i).after(index);
		(void) system(cmd.chars());
		if (auxFiles(i)[0] == '/' || auxFiles(i)[0] == '$')
			cmd = "ln -s " + auxFiles(i) + " .";
		else
			cmd = "ln -s ../" + auxFiles(i) + " .";
		if (verbose)
			fprintf(stderr, "%s\n", cmd.chars());
		if (system(cmd.chars()) != 0) {
			fprintf(stderr, "'%s' failed.\n", cmd.chars());
			return 1;
		}
	}
	if (keep) {
		if (verbose)
			fprintf(stderr, "make depend\n");
		if (system("make depend") != 0) {
			fprintf(stderr, "'make depend' failed.\n");
			return 1;
		}
	}

	// assert(!compileFiles.empty());
	cmd = String(compiler) + " -c " + cflags + " -I.. -I" + OTFHOME
		+ MOLINCLUDE_DIR + " *" + SUFFIX;

	if (verbose)
		fprintf(stderr, "%s\n", cmd.chars());
	if (system(cmd.chars()) != 0) {
		fprintf(stderr, "compile failed.\n");
		return 1;
	}

	cmd = String("ar cr lib") + output_name + ".a *.o";
	if (verbose)
		fprintf(stderr, "%s\n", cmd.chars());
	if (system(cmd.chars()) != 0) {
		fprintf(stderr, "ar failed.\n");
		return 1;
	}

	cmd = String("ranlib lib") + output_name + ".a";
	if (verbose)
		fprintf(stderr, "%s\n", cmd.chars());
	if (system(cmd.chars()) != 0)
		fprintf(stderr, "ranlib failed (but who cares).\n");

	if (!keep) {
		cmd = String("/bin/rm -f *") + SUFFIX + " *.o";
		if (verbose)
			fprintf(stderr, "%s\n", cmd.chars());
		if (system(cmd.chars()) != 0) {
			fprintf(stderr, "'%s' failed.\n", cmd.chars());
			return 1;
		}
	}
	return 0;
}
