// Copyright 1993, U.C.S.F. Computer Graphics Laboratory
// $Id: lex.h,v 2.6 1994/09/07 18:14:13 gregc Exp $

#ifndef Lex_h
#define Lex_h

#include <stdio.h>
#include <String.h>

class Lex {
public:
	enum Token {
		SOI, EOI, MEMBERS, CONSTRUCTOR, DESTRUCTOR, USE, FOR, IN,
		FEATURE, KEYMEMBER, KEYTYPE, RENAME, TO, NAMED,
		INCLUDE_FILE, AUX_FILE, COLON, LEFT_CURLY, RIGHT_CURLY,
		LEFT_PAREN, RIGHT_PAREN, SEMICOLON, IDENT, MEMBERDATAFUNC,
		ANY
	};
private:
	FILE	*f;
	String	filename;
	int	line_num;
	String	ident;
	Token	t;
	void	(*errFunc)(Lex *);
public:
	static char const	*const tokenNames[];
			Lex(const char *fname);
			~Lex() { if (f != NULL) fclose(f); }
	int		nextToken(Token tok = ANY);
	Token		token() { return t; }
	const String	&id() { return ident; }
	const String	&fileName() { return filename; }
	int		lineNum() { return line_num; }
	String		snarfText(char end_char);
	String		getFilename();
	void		errorFunction(void (*ef)(Lex *)) { errFunc = ef; }
	void		(*errorFunction())(Lex *) { return errFunc; }
};
#endif
