// Copyright 1993, U.C.S.F. Computer Graphics Laboratory
// $Id: mcd.h,v 2.7 94/01/12 19:39:36 gregc Exp $

#ifndef MCD_H
#define	MCD_H

#include <stdio.h>
#include <SLList.h>
#include <String.h>

#ifndef NULL
#define	NULL	0
#endif

extern int	verbose;
extern const char	*OTFHOME;

// MolClasses are partially ordered so that earlier classes are
// contained in latter classes
enum MolClasses {
	Bond, Atom, Ring, Residue, Coord, CoordSet, Molecule
};
const int	MAX_MOLCLASS	= Molecule;
extern char const	*molClassNames[MAX_MOLCLASS + 1];
extern char const	*origClassNames[MAX_MOLCLASS + 1];

class Members {
public:
	String	baseClassList;
	String	memberText;
		Members(): baseClassList(), memberText() {}
};

struct Constructor {
	String	arguments;
	String	memberInit;
	String	setupCode;
};

struct ContainerInfo {
	String	name;			// name of container
	String	instance;		// name of instance of container
	String	keyMember;		// key's access method
	String	keyType;		// key's type
};

// the following variables contain the contents of the Molecule Class
// Description file
extern SLList<Constructor>	constructors[MAX_MOLCLASS + 1];
extern Members		members[MAX_MOLCLASS + 1];
extern String		cleanupCode[MAX_MOLCLASS + 1];
extern ContainerInfo	use[MAX_MOLCLASS + 1][MAX_MOLCLASS + 1];	// Map?
extern SLList<String>	includeFiles[MAX_MOLCLASS + 1];
extern SLList<String>	auxFiles;

// the following variables contain intermediate results
extern SLList<String>	compileFiles;

extern void	parse_mcd_file(const char *);
extern void	default_use();
extern void	initialize_class_information();
extern void	genClasses(const char *output_name);
extern String	class_operators(int for_class, const char *base);
extern String	expand_add_element(int indent, int for_class, int in_class, const char *container);
extern String	expand_del_element(int indent, int for_class, int in_class, const char *container);
extern String	expand_iterator(int for_class, int in_class);
extern void	write_mcd_header(const char *output_name);
extern void	write_mcd_body(const char *output_name);

extern int	isTemplate(const String &name);
extern int	isMap(const String &name);

inline int
isPtr(int for_class)
{
	return (for_class != Coord);
}

#endif
