#include "BBox.h"

//
// Constructor
//
BBox::BBox(float x1, float x2, float y1, float y2)
{
	setBounds(x1, x2, y1, y2);
}

//
// Constructor
//
BBox::BBox(const float pt1[2], const float pt2[2])
{
	init_ = 1;
	setBounds(pt1[0], pt2[0], pt1[1], pt2[1]);
}

//
// Set the bounding coordinates
//
void
BBox::setBounds(float x1, float x2, float y1, float y2)
{
	init_ = 1;
	if (x1 < x2) {
		left_ = x1;
		right_ = x2;
	}
	else {
		left_ = x2;
		right_ = x1;
	}
	if (y1 < y2) {
		bottom_ = y1;
		top_ = y2;
	}
	else {
		bottom_ = y2;
		top_ = y1;
	}
}

//
// Add a point and recompute the bounding box
//
void
BBox::addPoint(float x, float y)
{
	if (init_ == 0) {
		left_ = right_ = x;
		top_ = bottom_ = y;
		init_ = 1;
		return;
	}
	if (x < left_)
		left_ = x;
	else if (x > right_)
		right_ = x;
	if (y < bottom_)
		bottom_ = y;
	else if (y > top_)
		top_ = y;
}

//
// Check if two bounding boxes overlap
//
int
BBox::overlaps(const BBox &bbox) const
{
	if (left_ > bbox.right_)
		return 0;
	if (right_ < bbox.left_)
		return 0;
	if (bottom_ > bbox.top_)
		return 0;
	if (top_ < bbox.bottom_)
		return 0;
	return 1;
}

//
// Check if given point falls inside the bounding box
//
int
BBox::contains(float x, float y) const
{
	if (x < left_ || x > right_)
		return 0;
	if (y < bottom_ || y > top_)
		return 0;
	return 1;
}
