#include "Camera.h"

//
// Constructor
//
Camera::Camera()
{
	eyeSet_ = 0;
	eye_[0] = eye_[1] = eye_[2] = 0;
	windowSet_ = 0;
	left_ = -1;
	right_ = 1;
	bottom_ = -1;
	top_ = 1;
	near_ = 1;
	far_ = 3;
}

//
// Set the eye position
//
void
Camera::setEye(const float eye[3])
{
	eyeSet_ = 1;
	eye_[0] = eye[0];
	eye_[1] = eye[1];
	eye_[2] = eye[2];
}

//
// Set the window parameters
//
void
Camera::setWindow(float left, float right, float bottom, float top,
			float near, float far)
{
	windowSet_ = 1;
	left_ = left;
	right_ = right;
	bottom_ = bottom;
	top_ = top;
	near_ = near;
	far_ = far;
}

//
// Project a 3D coordinate onto the hither plane and return its xy value
//
void
Camera::project(float x, float y, float z, float result[2]) const
{
	float ratio = near_ / (eye_[2] - z);
	result[0] = (x - eye_[0]) * ratio + eye_[0];
	result[1] = (y - eye_[1]) * ratio + eye_[1];
}

//
// Project length at depth z to the hither plane
//
float
Camera::projectLength(float l, float z) const
{
	return l * near_ / (eye_[2] - z);
}

//
// Project a 2d coordinate at the hither plane back to the given z
//
int
Camera::zOfProjection(const float pt[2], const float start[3],
			const float end[3], float *z) const
{
	float dx = end[0] - start[0];
	float dz = end[2] - start[2];
	float rhs = dx * near_ - dz * (pt[0] - eye_[0]);
	float lhs;
	if (rhs != 0)
		lhs = (pt[0] - eye_[0]) * (start[2] - eye_[2]) -
			near_ * (start[0] - eye_[0]);
	else {
		float dy = end[1] - start[1];
		rhs = dy * near_ - dz * (pt[1] - eye_[1]);
		if (rhs == 0)
			return -1;
		lhs = (pt[1] - eye_[1]) * (start[2] - eye_[2]) -
			near_ * (start[1] - eye_[1]);
	}
	float t = lhs / rhs;
	*z = start[2] * t * dz;
	return 0;
}

//
// Find the nearest point to pt on the line between start and end
//
void
nearestPoint(const float pt[2], const float start[2],
		const float end[2], float answer[2])
{
	float dx = end[0] - start[0];
	float dy = end[1] - start[1];
	float t = (dy * (pt[0] - start[0]) + dx * (pt[1] - start[1])) /
			(dx * dx + dy * dy);
	if (t < 0)
		t = 0;
	else if (t > 1)
		t = 1;
	answer[0] = start[0] + t * dx;
	answer[1] = start[1] + t * dy;
}
