#ifndef camera_h
#define camera_h

class Camera {
	int		eyeSet_;
	float		eye_[3];
	int		windowSet_;
	float		left_, right_, bottom_, top_;
	float		near_, far_;
public:
			Camera();
	void		setEye(const float eye[3]);
	void		setWindow(float left, float right, float bottom,
					float top, float near, float far);
	const float	*eye() const { return eye_; }
	float		left() const { return left_; }
	float		right() const { return right_; }
	float		bottom() const { return bottom_; }
	float		top() const { return top_; }
	float		near() const { return near_; }
	float		far() const { return far_; }
	int		eyeSet() const { return eyeSet_; }
	int		windowSet() const { return windowSet_; }
	void		project(float x, float y, float z,
				float result[2]) const;
	float		projectLength(float l, float z) const;
	int		zOfProjection(const float pt[2], const float start[3],
					const float end[3], float *z) const;
};

extern void	nearestPoint(const float pt[2], const float start[2],
				const float end[2], float answer[2]);

#endif
