#include <stdio.h>
#include "Drawn.h"

//
// Add another object that must be drawn before we are drawn
//
int
Drawn::isAfter(Drawn *d)
{
	if (d->checkAfter(this) < 0)
		return -1;
	afterList_.append(d);
	return 0;
}

//
// Check if we are about to create an inconsistency
//
int
Drawn::checkAfter(Drawn *after)
{
	for (Pix p = afterList_.first(); p != 0; afterList_.next(p)) {
		Drawn *d = afterList_(p);
		if (d == after || d->checkAfter(after) < 0)
			return -1;
	}
	return 0;
}

//
// Check if we can be drawn
//
int
Drawn::canDraw()
{
	for (Pix p = afterList_.first(); p != 0; afterList_.next(p))
		if (!afterList_(p)->drawn())
			return 0;
	return 1;
}

//
// Draw this object
//
int
Drawn::draw()
{
	int drawIt = 1;
	for (Pix p = afterList_.first(); p != 0; afterList_.next(p)) {
		Drawn *d = afterList_(p);
		if (!d->drawn() && !d->draw())
			drawIt = 0;
	}
	if (!drawIt)
		return 0;
	drawThis();
	drawn_ = 1;
	return 1;
}
