// This may look like C code, but it is really -*- C++ -*-
// WARNING: This file is obsolete.  Use ../SLList.h, if you can.
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _DrawnPtrSLList_h
#ifdef __GNUG__
#pragma interface
#endif
#define _DrawnPtrSLList_h 1

#include <Pix.h>
#include "DrawnPtr.defs.h"

#ifndef _DrawnPtrSLListNode_h
#define _DrawnPtrSLListNode_h 1

struct DrawnPtrSLListNode
{
  DrawnPtrSLListNode*         tl;
  DrawnPtr                    hd;
                         DrawnPtrSLListNode() { }
                         DrawnPtrSLListNode(const DrawnPtr  h, DrawnPtrSLListNode* t = 0);
                         ~DrawnPtrSLListNode() { }
};


inline DrawnPtrSLListNode::DrawnPtrSLListNode(const DrawnPtr  h, DrawnPtrSLListNode* t)
:hd(h), tl(t) {}

typedef DrawnPtrSLListNode* DrawnPtrSLListNodePtr;

#endif


class DrawnPtrSLList
{
protected:
  DrawnPtrSLListNode*        last;

public:
                        DrawnPtrSLList();
                        DrawnPtrSLList(const DrawnPtrSLList& a);
                        ~DrawnPtrSLList();

  DrawnPtrSLList&            operator = (const DrawnPtrSLList& a);

  int                   empty();
  int                   length();

  void                  clear();

  Pix                   prepend(DrawnPtr  item);
  Pix                   append(DrawnPtr  item);

  void                  join(DrawnPtrSLList&);

  Pix                   prepend(DrawnPtrSLListNode*);
  Pix                   append(DrawnPtrSLListNode*);

  DrawnPtr&                  operator () (Pix p);
  Pix                   first();
  void                  next(Pix& p);
  int                   owns(Pix p);
  Pix                   ins_after(Pix p, DrawnPtr  item);
  void                  del_after(Pix p);

  DrawnPtr&                  front();
  DrawnPtr&                  rear();
  DrawnPtr                   remove_front();
  int                   remove_front(DrawnPtr& x);
  void                  del_front();

  void                  error(const char* msg);
  int                   OK();
};

inline DrawnPtrSLList::~DrawnPtrSLList()
{
  clear();
}

inline DrawnPtrSLList::DrawnPtrSLList()
{
  last = 0;
}

inline int DrawnPtrSLList::empty()
{
  return last == 0;
}


inline Pix DrawnPtrSLList::first()
{
  return (last == 0)? 0 : Pix(last->tl);
}

inline void DrawnPtrSLList::next(Pix& p)
{
  p = (p == 0 || p == last)? 0 : Pix(((DrawnPtrSLListNode*)(p))->tl);
}

inline DrawnPtr& DrawnPtrSLList::operator () (Pix p)
{
  if (p == 0) error("null Pix");
  return ((DrawnPtrSLListNode*)(p))->hd;
}

inline DrawnPtr& DrawnPtrSLList::front()
{
  if (last == 0) error("front: empty list");
  return last->tl->hd;
}

inline DrawnPtr& DrawnPtrSLList::rear()
{
  if (last == 0) error("rear: empty list");
  return last->hd;
}

#endif
