#include "Mol/Molecule.h"
#include <pdbio/PDBio.h>
#include <GetOpt.h>

typedef PDBio<Bond, Atom, Residue, Coord, CoordSet, Molecule>	IOpdb;
IOpdb	pdb_io;

int
main(int argc, char **argv)
{
	GetOpt	getopt(argc, argv, "hs");
	int	c;

	while ((c = getopt()) != EOF) switch (c) {
	case 'h': pdb_io.whatToDo().set(IOpdb::HYDROGEN_BONDS); break;
	case 's': pdb_io.whatToDo().set(IOpdb::SALT_BRIDGES); break;
	default: goto usage;
	}
	if (argc > getopt.optind + 1) {
usage:
		cerr << "usage: " << argv[0] << " [-h] [-s] [pdb-file]" << endl;
		return 1;
	}

	if (argc == getopt.optind)
		pdb_io.readPDBfile(NULL);
	else
		pdb_io.readPDBfile(argv[getopt.optind]);
	if (!pdb_io.okay()) {
		cerr << argv[0] << ": " << pdb_io.error() << endl;
		return 1;
	}

	Molecule *m = pdb_io.molecule();
	for (CIter<CoordSet> ci = m->citerCoordSet(); ci.ok(); ci.next()) {
		m->activeCoordSet(ci);
		for (CIter<Bond> bi = m->citerBond(); bi.ok(); bi.next()) {
			Coord	*c0 = bi->lookupAtom(0)->getCoord(),
				*c1 = bi->lookupAtom(1)->getCoord();
			cout << ".m " << c0->xyz[0] << ' ' << c0->xyz[1] << ' '
				<< c0->xyz[2] << endl << ".d " << c1->xyz[0]
				<< ' ' << c1->xyz[1] << ' ' << c1->xyz[2]
				<< endl;
		}
	}

	return 0;
}
