#include "efence.h"
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

/*
 * For some reason, I can't find mprotect() in any of the headers on
 * IRIX or SunOS 4.1.2
 */
extern C_LINKAGE int mprotect(caddr_t addr, size_t len, int prot);

static int	devZeroFd = -1;

#if ( !defined(sgi) )
extern int	sys_nerr;
extern char *	sys_errlist[];
#endif

static const char *
stringErrorReport(void)
{
#if ( defined(sgi) )
	return strerror(oserror());
#else
	if ( errno > 0 && errno < sys_nerr )
		return sys_errlist[errno];
	else
		return "Unknown error.\n";
#endif
}

/*
 * Create memory.
 */
void *
Page_Create(size_t size)
{
	void *		allocation;


	if ( devZeroFd == -1 ) {
		devZeroFd = open("/dev/zero", O_RDWR);
		if ( devZeroFd < 0 )
			EF_Exit(
			 "open() on /dev/zero failed: "
			,stringErrorReport());
	}

	allocation = mmap(
	 0
	,(int)size
	,PROT_READ|PROT_WRITE
	,MAP_PRIVATE
	,devZeroFd
	,0);

	if ( allocation == (void *)-1 )
		EF_Exit("mmap() failed: ", stringErrorReport());

	return allocation;
}

static void
mprotectFailed(void)
{
	EF_Exit("mprotect() failed: ", stringErrorReport());
}

void
Page_AllowAccess(void * address, size_t size)
{
	if ( mprotect((caddr_t)address, size, PROT_READ|PROT_WRITE) < 0 )
		mprotectFailed();
}

void
Page_DenyAccess(void * address, size_t size)
{
	if ( mprotect((caddr_t)address, size, PROT_NONE) < 0 )
		mprotectFailed();
}

#ifdef	_SC_PAGESIZE
size_t
Page_Size(void)
{
	return (size_t)sysconf(_SC_PAGESIZE);
}
#else
extern int	getpagesize();
size_t
Page_Size(void)
{
	return getpagesize();
}
#endif
