// Copyright 1994, U.C.S.F. Computer Graphics Laboratory
// $Id$

#include "Symbol.h"

class AtomType {
public:
	enum AT {
		Unknown,
		C3,	// sp3-hybridized carbon
		C2,	// sp2-hybridized carbon
		C1,	// sp-hybridized carbon
		Cac,	// carboxylate carbon
		N3P,	// sp3-hybridized nitrogen, formal positive charge
		N3,	// sp3-hybridized nitrogen, neutral
		Npl,	// sp2-hybridized nitrogen
		N1,	// sp-hybridized nitrogen
		Nox,	// N-oxide nitrogen
		Ntr,	// nitro nitrogen
		NgP,	// guanidinium nitrogen, partial positive charge
		O3,	// sp3-hybridized oxygen
		O2,	// sp2-hybridized oxygen
		OM,	// carboxylate or nitro oxygen, partial negative charge
		S3P,	// sp3-hybridized sulfer, partial positive charge
		S3,	// sp3-hybridized sulfer, neutral
		S2,	// sp2-hybridized sulfer
		Sac,	// sulfate sulfer
		Sox,	// sulfoxide or sulfone sulfer
		S,	// other sulfer
		Bac,	// borate boron
		Box,	// other oxidized boron
		B,	// other boron (not oxidized)
		Pac,	// phosphate phosphorus
		Pox,	// P-oxide phosphorus
		P3P,	// sp3-hybridized phosphours, partial positive charge
		P,	// other phosphours
		HC,	// hydrogen bonded to carbon
		H,	// other hydrogen
		DC,	// deuterium bonded to carbon
		D	// other deuterium
	};
private:
	static const char * const
			types[D + 1];
	Symbol		at;		// atomic number
public:
		AtomType(): at(types[Unknown]) {}
		AtomType(const char *name): at(name) {}
		AtomType(Symbol sym): at(sym) {}
		AtomType(AT a) {
			if (a > D)
				at = types[Unknown];
			else
				at = types[a];
		}
	Symbol	name() const { return at; };
	bool	operator==(const AtomType &a) const { return at == a.at; }
	bool	operator!=(const AtomType &a) const { return at != a.at; }
	bool	operator<(const AtomType &a) const { return at <= a.at; }
	bool	operator<=(const AtomType &a) const { return at <= a.at; }
	bool	operator>(const AtomType &a) const { return at > a.at; }
	bool	operator>=(const AtomType &a) const { return at >= a.at; }
};

inline ostream &
operator<<(ostream &os, const AtomType &a)
{
	os << a.name();
	return os;
}
