// Copyright 1994, U.C.S.F. Computer Graphics Laboratory
// $Id: AtomicSymbol.h,v 1.3 94/10/13 17:43:24 gregc Exp $

#include <iostream.h>

class AtomicSymbol {
public:
	enum AS {
		LonePair, H, D = 1, T = 1, He,
		Li, Be, B, C, N, O, F, Ne,
		Na, Mg, Al, Si, P, S, Cl, Ar,
		K, Ca, Sc, Ti, V, Cr, Mn, Fe, Co, Ni, Cu, Zn,
		Ga, Ge, As, Se, Br, Kr,
		Rb, Sr, Y, Zr, Nb, Mo, Tc, Ru, Rh, Pd, Ag, Cd,
		In, Sn, Sb, Te, I, Xe,
		Cs, Ba, La,
		Ce, Pr, Nd, Pm, Sm, Eu, Gd, Tb, Dy, Ho, Er, Tm, Yb, Lu,
		Hf, Ta, W, Re, Os, Ir, Pt, Au, Hg, Tl, Pb, Bi, Po, At, Rn,
		Fr, Ra, Ac,
		Th, Pa, U, Np, Pu, Am, Cm, Bk, Cf, Es, Fm, Md, No, Lr
	};
	static float	bondRadius(AtomicSymbol);
	static float	bondLength(AtomicSymbol, AtomicSymbol);
private:
	static AS	atomicNumber(const char *name);
	static const char * const
			symbols[Lr + 1];
	AS		as;		// atomic number
public:
		AtomicSymbol(const char *name): as(atomicNumber(name)) {}
		AtomicSymbol(AS a): as(a) {}
		AtomicSymbol(unsigned int i): as(AS(i)) {}
	const char	*name() const {
		if (as > Lr)
			return "??";
		return symbols[as];
	}
	int	number() const { return int(as); }
	bool	operator==(const AtomicSymbol &a) const { return as == a.as; }
	bool	operator!=(const AtomicSymbol &a) const { return as != a.as; }
	bool	operator<(const AtomicSymbol &a) const { return as <= a.as; }
	bool	operator<=(const AtomicSymbol &a) const { return as <= a.as; }
	bool	operator>(const AtomicSymbol &a) const { return as > a.as; }
	bool	operator>=(const AtomicSymbol &a) const { return as >= a.as; }
};

inline ostream &
operator<<(ostream &os, const AtomicSymbol &a)
{
	os << a.name();
	return os;
}
