// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: BaseMolecule.h,v 1.19 1994/10/04 23:24:30 gregc Exp $

#ifndef BaseMolecule_h
#define BaseMolecule_h

#include "AtomicSymbol.h"
#include "AtomType.h"
#include "Geom3d.h"
#include "MolResId.h"
#include "MolCoordSetId.h"
#include "MolComment.h"
#include "SymComPtrVHMap.h"

// predefined flags
const unsigned int	MOL_DELETE	= 0x1;
const unsigned int	MOL_MAX_FLAG	= 0x80;	// allow for growth

class BaseBond {
	float	order_;
public:
		BaseBond(): order_(1.0f) {}
		BaseBond(float o): order_(o) {}
	virtual	~BaseBond() {}
	float	order() const { return order_; }
	void	order(float o) { order_ = o; }
};

class BaseAtom {
	Symbol	name_;
	AtomicSymbol 	sym;
	AtomType	at;
protected:
	mutable int	index;
public:
		BaseAtom():
			name_(), sym(AtomicSymbol::C), at(), index(-1) {}
		BaseAtom(Symbol n, AtomicSymbol element):
			name_(n), sym(element), at(), index(-1) {}
		BaseAtom(Symbol n, AtomicSymbol element, AtomType at):
			name_(n), sym(element), at(at), index(-1) {}
	virtual	~BaseAtom() {}
	Symbol	name() const { return name_; }
	void	name(Symbol s) { name_ = s; }
	AtomicSymbol
		atomicSymbol() const { return sym; }
	void	atomicSymbol(AtomicSymbol s) { sym = s; }
	AtomType
		type() const { return at; }
	void	type(AtomType t) { at = t; }
	int	coordIndex() const { return index; }
	bool	operator==(const BaseAtom &a) const {
			return name_ == a.name_;
		}
	bool	operator<=(const BaseAtom &a) const {
			return name_ <= a.name_;
		}
};

class BaseResidue {
protected:
	Symbol		type_;
	MolResId	rid;
public:
		BaseResidue(Symbol t, const MolResId &id):
			type_(t), rid(id) {}
		BaseResidue(Symbol t, Symbol chain, int pos, char insert):
			type_(t), rid(chain, pos, insert) {}
	virtual	~BaseResidue() {}
	Symbol	type() const { return type_; }
	void	type(Symbol t) { type_ = t; }
	const MolResId &
		id() const { return rid; }
	bool	operator==(const BaseResidue &r) const {
			return rid == r.rid;
		}
	bool	operator<=(const BaseResidue &r) const {
			return rid <= r.rid;
		}
};

typedef Geom3d::Point	MolPos;		// 3-D coordinate positions

class BaseCoord {
public:
	MolPos	xyz;
		BaseCoord() {
			xyz.elem(0) = 0.0f;
			xyz.elem(1) = 0.0f;
			xyz.elem(2) = 0.0f;
		}
	bool	operator==(const BaseCoord &r) const {
			return xyz == r.xyz;
		}
};

class BaseCoordSet {
protected:
	MolCoordSetId	csid;
public:
		BaseCoordSet(const MolCoordSetId &id): csid(id) {}
	const MolCoordSetId &
		id() const { return csid; }
};

class BaseMolecule {
public:
	SymbolMolCommentPtrVHMap	comments;

		BaseMolecule(): comments((MolComment *) NULL) {}
	virtual	~BaseMolecule();
};

#endif
