// Copyright 1994, U.C.S.F. Computer Graphics Laboratory
// $Id: Geom3d.h,v 1.5 1995/01/09 21:01:19 gregc Exp $

#ifndef GEOM_H
#define	GEOM_H

#include "FixedAVector.h"

class Geom3d {		// TODO: change to namespace
public:
class Point: public FixedAVector<double, 3> {
	// disable FixedAVector functions that don't make sense for Point's
	Point operator+(const Point &) const;
	Point operator-(const Point &) const;
	Point operator+(double f) const;
	Point operator-(double f) const;
	Point operator*(double f) const;
	Point operator/(double f) const;
	Point operator+=(double f) const;
	Point operator-=(double f) const;
	Point operator*=(double f) const;
	Point operator/=(double f) const;
public:
	Point(): FixedAVector<double, 3>() {}
	Point(double p[3]): FixedAVector<double, 3>(p) {}
	Point(const FixedAVector<double, 3> &p): FixedAVector<double, 3>(p) {}
};

class Vector: public FixedAVector<double, 3> {
public:
	Vector(): FixedAVector<double, 3>() {}
	Vector(double v[3]): FixedAVector<double, 3>(v) {}
	Vector(const FixedAVector<double, 3> &v): FixedAVector<double, 3>(v) {}
};

/*
 *	Xform holds a orthonormal rotation 3x3 matrix and a translation
 *	vector.  Is it is analogous to a graphics library's homogeneous 4x4
 *	transformation matrix.
 */

class Xform {
private:
	double	rot[3][3];
	Vector	xlate, inv_xlate;
public:
		Xform() {}
		~Xform() {}
	void	setIdentity();
	void	setTranslate(double x, double y, double z);
	void	setTranslate(const Vector &xyz);
	void	setXRotate(double angle);
	void	setYRotate(double angle);
	void	setZRotate(double angle);
	void	setRotate(double x, double y, double z, double angle);
	void	setRotate(const Vector &xyz, double angle);
	void	setZAlign(const Point &p0, const Point &p1);
	void	setZAlign(const Point &p, const Vector &v);
	void	setLookAt(const Point &p0, const Point &p1, const Point &p2);
	void	invert();
	void	translate(double x, double y, double z);
	void	translate(const Vector &xyz);
	void	xRotate(double angle);
	void	yRotate(double angle);
	void	zRotate(double angle);
	void	rotate(double x, double y, double z, double angle);
	void	rotate(const Vector &xyz, double angle);
	Point	apply(const Point &p) const;
	Vector	apply(const Vector &p) const;
	void	multiply(const Xform &op);	// rename
	friend static ostream	&operator<<(ostream &os, const Xform &t);
};

static double	dihedral(const Geom3d::Point &p0, const Geom3d::Point &p1,
			const Geom3d::Point &p2, const Geom3d::Point &p3);

static double	angle(const Geom3d::Vector &v0, const Geom3d::Vector &v1);

static double	angle(const Geom3d::Point &p0, const Geom3d::Point &p1,
						const Geom3d::Point &p2);

};	// namespace Geom3d

inline Geom3d::Point
operator+(const Geom3d::Vector &l, const Geom3d::Point &r)
{
	return Geom3d::Point((const FixedAVector<double, 3> &) l
					+ (const FixedAVector<double, 3> &) r);
}

inline Geom3d::Point
operator+(const Geom3d::Point &l, const Geom3d::Vector &r)
{
	return Geom3d::Point((const FixedAVector<double, 3> &) l
					+ (const FixedAVector<double, 3> &) r);
}

inline Geom3d::Vector
operator-(const Geom3d::Point &l, const Geom3d::Point &r)
{
	return Geom3d::Vector((const FixedAVector<double, 3> &) l
					- (const FixedAVector<double, 3> &) r);
}

inline void
Geom3d::Xform::setZAlign(const Point &p, const Vector &v)
{
	setZAlign(p, p + v);
}

inline Geom3d::Point
lerp(const Geom3d::Point &l, const Geom3d::Point &r, double alpha)
{
	return Geom3d::Point(lerp((const FixedAVector<double, 3> &) l,
				(const FixedAVector<double, 3> &) r, alpha));
}

inline Geom3d::Vector
combine(const Geom3d::Vector &l, const Geom3d::Vector &r, double alpha, double beta)
{
	return Geom3d::Vector(combine((const FixedAVector<double, 3> &) l,
			(const FixedAVector<double, 3> &) r, alpha, beta));
}

inline Geom3d::Vector
cross(const Geom3d::Vector &l, const Geom3d::Vector &r)
{
	return Geom3d::Vector(cross((const FixedAVector<double, 3> &) l,
					(const FixedAVector<double, 3> &) r));
}

inline ostream &
operator<<(ostream &os, const Geom3d::Point &p)
{
	return os << (const FixedAVector<double, 3> &) p;
}

inline ostream &
operator<<(ostream &os, const Geom3d::Vector &v)
{
	return os << (const FixedAVector<double, 3> &) v;
}

inline ostream &
operator<<(ostream &os, const Geom3d::Xform &t)
{
	return os
	    << t.rot[0][0] << ' ' << t.rot[0][1] << ' ' << t.rot[0][2] << ' '
	    << t.xlate.elem(0) << endl
	    << t.rot[1][0] << ' ' << t.rot[1][1] << ' ' << t.rot[1][2] << ' '
	    << t.xlate.elem(1) << endl
	    << t.rot[2][0] << ' ' << t.rot[2][1] << ' ' << t.rot[2][2] << ' '
	    << t.xlate.elem(2) << endl;
}

#endif /* GEOM_H */
