// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: MolComment.h,v 1.6 1994/10/04 22:19:39 gregc Exp $

#ifndef MolComment_h
#define MolComment_h

#include "TimeStamp.h"

class MolComment;
typedef MolComment	*MolCommentPtr;

class MolComment {
	Symbol		_tag;
	TimeStamp	ts;
	String		comment;
public:
		MolComment(Symbol tag, const TimeStamp &whoWhen,
							const String &text):
			_tag(tag), ts(whoWhen), comment(text) {}
		MolComment(Symbol tag, const char *who, const String &text):
			_tag(tag), ts(time(NULL), who), comment(text) {}
	Symbol	tag() const { return _tag; }
	const TimeStamp &
		timeStamp() const { return ts; }
	const String &
		text() const { return comment; }
};

#endif
