// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: MolCoordSetId.cc,v 1.5 1994/10/04 22:19:39 gregc Exp $

#include "MolCoordSetId.h"
#include <strstream.h>
#include <builtin.h>

const char *
MolCoordSetId::chars() const
{
	static ostrstream	*os;

	if (os == NULL)
		os = new ostrstream;
	else
		os->seekp(0, ios::beg);
	*os << name_.str() << pos << ends;
	return os->str();
}

int
hash(const MolCoordSetId &id)
{
	return hashpjw(id.name().chars()) + multiplicativehash(id.position());
}
