// Copyright 1993, U.C.S.F. Computer Graphics Laboratory
// $Id: MolCoordSetId.h,v 1.6 1994/10/04 22:19:39 gregc Exp $

// coordinate set identifiers

#ifndef MolCoordSetId_h
#define MolCoordSetId_h

#include "Symbol.h"

class MolCoordSetId {
	Symbol	name_;			/* run/trajectory name */
	int	pos;			/* position */
public:
		MolCoordSetId(): name_(), pos(0) {}
		MolCoordSetId(Symbol n, int pos = 0): name_(n), pos(pos) {}
	Symbol	name() const { return name_; }
	int	position() const { return pos; }
	const char *
		chars() const;
	int	sameChain(const MolCoordSetId &id) const {
			return name_ == id.name_;
		}
	int	operator<(const MolCoordSetId &id) const;
	int	operator<=(const MolCoordSetId &id) const;
	int	operator>(const MolCoordSetId &id) const;
	int	operator>=(const MolCoordSetId &id) const;
	int	operator==(const MolCoordSetId &id) const;
	int	operator!=(const MolCoordSetId &id) const;
};

inline int
MolCoordSetId::operator<(const MolCoordSetId &id) const
{
	return (name_ < id.name_ || pos < id.pos);
}

inline int
MolCoordSetId::operator<=(const MolCoordSetId &id) const
{
	return !(name_ > id.name_ || pos > id.pos);
}

inline int
MolCoordSetId::operator>(const MolCoordSetId &id) const
{
	return (name_ > id.name_ || pos > id.pos);
}

inline int
MolCoordSetId::operator>=(const MolCoordSetId &id) const
{
	return !(name_ < id.name_ || pos < id.pos);
}

inline int
MolCoordSetId::operator==(const MolCoordSetId &id) const
{
	return name_ == id.name_ && pos == id.pos;
}

inline int
MolCoordSetId::operator!=(const MolCoordSetId &id) const
{
	return name_ != id.name_ || pos != id.pos;
}

inline ostream &
operator<<(ostream &os, const MolCoordSetId &id)
{
	os << id.chars();
	return os;
}

#endif /* MolCoordSetId_h */
