// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: MolResId.cc,v 1.4 1994/10/04 22:19:39 gregc Exp $

#include "MolResId.h"
#include <strstream.h>
#include <builtin.h>

const char *
MolResId::chars() const
{
	static ostrstream	*os;

	if (os == NULL)
		os = new ostrstream;
	else
		os->seekp(0, ios::beg);
	if (cid.str() != ' ')
		*os << cid.str();
	*os << pos;
	if (ic != ' ')
		*os << ic;
	*os << ends;
	return os->str();
}

int
hash(const MolResId &ms)
{
	return hashpjw(ms.chainId().chars())
					+ multiplicativehash(ms.position());
}
