// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: MolResId.h,v 1.13 1994/10/04 22:19:39 gregc Exp $

// residue sequence numbers

#ifndef MolResId_h
#define MolResId_h

#include "Symbol.h"

class MolResId {
	Symbol	cid;			/* chain identifier */
	int	pos;			/* position */
	char	ic;			/* insertion code */
public:
		MolResId(int pos): cid(' '), pos(pos), ic(' ') {}
		MolResId(int pos, char insert): cid(' '), pos(pos), ic(insert) {
			if (ic == '\0')
				ic = ' ';
		}
		MolResId(Symbol chain, int pos, char insert):
					cid(chain), pos(pos), ic(insert) {
			if (cid.str().empty())
				cid = " ";
			if (ic == '\0')
				ic = ' ';
		}
		MolResId(char chain, int pos, char insert):
							pos(pos), ic(insert) {
			if (chain == '\0')
				cid = " ";
			else
				cid = String(chain);
			if (ic == '\0')
				ic = ' ';
		}
	Symbol	chainId() const { return cid; }
	int	position() const { return pos; }
	char	insertionCode() const { return ic; }
	const char	*chars() const;
	bool	sameChain(const MolResId &rid) const { return cid == rid.cid; }
	bool	operator<(const MolResId &rid) const;
	bool	operator<=(const MolResId &rid) const;
	bool	operator>(const MolResId &rid) const;
	bool	operator>=(const MolResId &rid) const;
	bool	operator==(const MolResId &rid) const;
	bool	operator!=(const MolResId &rid) const;
};

inline bool
MolResId::operator<(const MolResId &rid) const
{
	return cid < rid.cid || (cid == rid.cid && pos < rid.pos)
			|| (cid == rid.cid && pos == rid.pos && ic < rid.ic);
}

inline bool
MolResId::operator<=(const MolResId &rid) const
{
	return cid < rid.cid || (cid == rid.cid && pos < rid.pos)
			|| (cid == rid.cid && pos == rid.pos && ic <= rid.ic);
}

inline bool
MolResId::operator>(const MolResId &rid) const
{
	return cid > rid.cid || (cid == rid.cid && pos > rid.pos)
			|| (cid == rid.cid && pos == rid.pos && ic > rid.ic);
}

inline bool
MolResId::operator>=(const MolResId &rid) const
{
	return cid > rid.cid || (cid == rid.cid && pos > rid.pos)
			|| (cid == rid.cid && pos == rid.pos && ic >= rid.ic);
}

inline bool
MolResId::operator==(const MolResId &rid) const
{
	return cid == rid.cid && pos == rid.pos && ic == rid.ic;
}

inline bool
MolResId::operator!=(const MolResId &rid) const
{
	return cid != rid.cid || pos != rid.pos || ic != rid.ic;
}

inline ostream &
operator<<(ostream &os, const MolResId &rid)
{
	os << rid.chars();
	return os;
}

#endif /* MolResId_h */
