// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: Symbol.cc,v 1.7 1994/10/04 22:19:39 gregc Exp $

#include "Symbol.h"
#include <builtin.h>
#include "StrPtrVHSet.h"

static StringPtrVHSet	sym_table(1031);

Symbol::Symbol(const char *cp)
{
	if (cp == NULL) {
		sym = &_nilString;
		return;
	}
	String *s = new String(cp);
	Pix p = sym_table.seek(s);
	if (p == 0)
		p = sym_table.add(s);
	else
		delete s;
	sym = sym_table(p);
}

Symbol::Symbol(const String &orig)
{
	if (orig.empty()) {
		sym = &_nilString;
		return;
	}
	Pix p = sym_table.seek(&orig);
	if (p == 0) {
		String *s = new String(orig);
		p = sym_table.add(s);
	}
	sym = sym_table(p);
}

unsigned int
hash(const Symbol &s)
{
	return hashpjw(s.chars());
}
