// required file for genclass'd file from GNU libg++ library
// $Id: Symbol.defs.h,v 1.4 93/08/20 14:21:21 gregc Exp $

#ifndef Symbol_defs_h
#define Symbol_defs_h

#include "Symbol.h"

#define SymbolEQ(a, b)  ((a) == (b))

#define SymbolLE(a, b)  ((a) <= (b))

#define SymbolCMP(a, b) ( ((a) <= (b))? (((a) == (b))? 0 : -1) : 1 )

extern unsigned int hash(const Symbol &);
#define SymbolHASH(x)  hash(x)

#ifndef DEFAULT_INITIAL_CAPACITY
#define DEFAULT_INITIAL_CAPACITY 100
#endif

#ifndef HASHTABLE_TOO_CROWDED
#define HASHTABLE_TOO_CROWDED(COUNT, SIZE) ((SIZE) - ((SIZE) >> 3) <= (COUNT))
#endif

#endif
