// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: Symbol.h,v 1.15 1994/10/04 22:19:39 gregc Exp $

#ifndef Symbol_h
#define Symbol_h

#include <String.h>

class Symbol {
	const String		*sym;
public:
		Symbol() { sym = &_nilString; }
		Symbol(const char *cp);
		Symbol(const String &orig);
		Symbol(const Symbol &s) { sym = s.sym; }
	bool	operator==(Symbol s) const { return sym == s.sym; }
	bool	operator!=(Symbol s) const { return sym != s.sym; }
	bool	operator<(Symbol s) const { return *sym < *s.sym; }
	bool	operator<=(Symbol s) const { return *sym <= *s.sym; }
	bool	operator>(Symbol s) const { return *sym > *s.sym; }
	bool	operator>=(Symbol s) const { return *sym >= *s.sym; }
	bool	empty() const { return sym->empty(); }
	const String	&str() const { return *sym; }
	const char	*chars() const { return sym->chars(); }
};

inline bool
operator==(Symbol sym, const String &str)
{
	return sym.str() == str;
}
inline bool
operator!=(Symbol sym, const String &str)
{
	return sym.str() != str;
}
inline bool
operator<(Symbol sym, const String &str)
{
	return sym.str() < str;
}
inline bool
operator<=(Symbol sym, const String &str)
{
	return sym.str() <= str;
}
inline bool
operator>(Symbol sym, const String &str)
{
	return sym.str() > str;
}
inline bool
operator>=(Symbol sym, const String &str)
{
	return sym.str() >= str;
}

inline bool operator==(const String &str, Symbol sym)
{
	return str == sym.str();
}
inline bool operator!=(const String &str, Symbol sym)
{
	return str != sym.str();
}
inline bool operator<(const String &str, Symbol sym)
{
	return str < sym.str();
}
inline bool operator<=(const String &str, Symbol sym)
{
	return str <= sym.str();
}
inline bool operator>(const String &str, Symbol sym)
{
	return str > sym.str();
}
inline bool operator>=(const String &str, Symbol sym)
{
	return str >= sym.str();
}
inline ostream &operator<<(ostream &os, const Symbol &s)
{
	os << s.chars();
	return os;
}

#endif
