// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: TimeStamp.cc,v 1.3 1994/10/04 22:19:39 gregc Exp $

#include "TimeStamp.h"

extern "C" {
#include <string.h>
#include <time.h>
}

bool
TimeStamp::operator==(const TimeStamp &ts) const
{
	return date == ts.date && user == ts.user;
}

bool
TimeStamp::operator!=(const TimeStamp &ts) const
{
	return date != ts.date || user != ts.user;
}

bool
TimeStamp::operator<(const TimeStamp &ts) const
{
	return date < ts.date || (date == ts.date && user < ts.user);
}

bool
TimeStamp::operator<=(const TimeStamp &ts) const
{
	return date < ts.date || (date == ts.date && user <= ts.user);
}

bool
TimeStamp::operator>(const TimeStamp &ts) const
{
	return date > ts.date || (date == ts.date && user > ts.user);
}

bool
TimeStamp::operator>=(const TimeStamp &ts) const
{
	return date > ts.date || (date == ts.date && user >= ts.user);
}

const char *
TimeStamp::chars() const
{
	static char	buf[64];

	(void) strcpy(buf, ctime(&date));
	buf[24] = ' ';
	(void) strncpy(&buf[25], user.chars(), sizeof buf - 25);
	return buf;
}
