// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: TimeStamp.h,v 1.6 1994/10/04 22:19:39 gregc Exp $

#ifndef TimeStamp_h
#define TimeStamp_h

#include "Symbol.h"
extern "C" {
#include <sys/types.h>

extern time_t	time(time_t *);
}

class TimeStamp {
	time_t	date;
	Symbol	user;
public:
		TimeStamp(time_t t, const char *who): date(t), user(who) {}
		TimeStamp(time_t t, const String &who): date(t), user(who) {}
		TimeStamp(time_t t, Symbol who): date(t), user(who) {}
	Symbol	who() const { return user; }
	time_t	when() const { return date; }
	bool	operator==(const TimeStamp &ts) const;
	bool	operator!=(const TimeStamp &ts) const;
	bool	operator<(const TimeStamp &ts) const;
	bool	operator<=(const TimeStamp &ts) const;
	bool	operator>(const TimeStamp &ts) const;
	bool	operator>=(const TimeStamp &ts) const;
	const char	*chars() const;
};

inline ostream &
operator<<(ostream &os, const TimeStamp &ts)
{
	os << ts.chars();
	return os;
}

#endif
