#include "Geom3d.h"
#include <GetOpt.h>

#ifndef M_PI_2
#define	M_PI_2	1.5707963267948966192E0f
#endif

float
deg_to_rad(float d)
{
	return d * M_PI_2 / 90.0f;
}

int
arg1(const char *cp, float *a)
{
	char	*end;

	if (cp == NULL)
		goto error;
	*a = strtod(cp, &end);
	if (end == cp)
		goto error;
	if (end == NULL || *end == '\0')
		return 0;
error:
	cerr << "expected one floating point argument" << endl;
	return 1;
}

int
arg3(const char *cp, float *x, float *y, float *z)
{
	char	*end;

	if (cp == NULL)
		goto error;
	*x = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*y = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*z = strtod(cp, &end);
	if (end == cp)
		goto error;
	if (end == NULL || *end == '\0')
		return 0;
error:
	cerr << "expected three floating point arguments" << endl;
	return 1;
}

int
arg4(const char *cp, float *x, float *y, float *z, float *a)
{
	char	*end;

	if (cp == NULL)
		goto error;
	*x = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*y = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*z = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*a = strtod(cp, &end);
	if (end == cp)
		goto error;
	if (end == NULL || *end == '\0')
		return 0;
error:
	cerr << "expected four floating point arguments" << endl;
	return 1;
}

int
arg6(const char *cp, float *x, float *y, float *z, float *a, float *b, float *c)
{
	char	*end;

	if (cp == NULL)
		goto error;
	*x = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*y = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*z = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*a = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*b = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*c = strtod(cp, &end);
	if (end == cp)
		goto error;
	if (end == NULL || *end == '\0')
		return 0;
error:
	cerr << "expected six floating point arguments" << endl;
	return 1;
}

int
arg9(const char *cp, float *x, float *y, float *z, float *a, float *b, float *c,	float *d, float *e, float *f)
{
	char	*end;

	if (cp == NULL)
		goto error;
	*x = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*y = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*z = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*a = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*b = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*c = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*d = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*e = strtod(cp, &end);
	if (end == cp || end == NULL || *end == '\0')
		goto error;
	cp = end + 1;
	*f = strtod(cp, &end);
	if (end == cp)
		goto error;
	if (end == NULL || *end == '\0')
		return 0;
error:
	cerr << "expected six floating point arguments" << endl;
	return 1;
}

int
main(int argc, char **argv)
{
	Geom3d::Xform	t;
	Geom3d::Point	p0, p1, p2;
	GetOpt  getopt(argc, argv, ".A:IL:R:T:X:Y:Z:a:ipr:t:x:y:z:");
	int     c;
	float	x, y, z, a;

	t.setIdentity();
	while ((c = getopt()) != EOF) switch (c) {
	case 'I': t.setIdentity(); break;
	case 'L':
		if (arg9(getopt.optarg, &p0.elem(0), &p0.elem(1), &p0.elem(2),
					&p1.elem(0), &p1.elem(1), &p1.elem(2),
					&p2.elem(0), &p2.elem(1), &p2.elem(2)))
			goto usage;
		t.setLookAt(p0, p1, p2);
		break;
	case 'T':
		if (arg3(getopt.optarg, &x, &y, &z))
			goto usage;
		t.setTranslate(x, y, z);
		break;
	case 'X':
		if (arg1(getopt.optarg, &a))
			goto usage;
		t.setXRotate(deg_to_rad(a));
		break;
	case 'Y':
		if (arg1(getopt.optarg, &a))
			goto usage;
		t.setYRotate(deg_to_rad(a));
		break;
	case 'Z':
		if (arg1(getopt.optarg, &a))
			goto usage;
		t.setZRotate(deg_to_rad(a));
		break;
	case 'R':
		if (arg4(getopt.optarg, &x, &y, &z, &a))
			goto usage;
		t.setRotate(x, y, z, deg_to_rad(a));
		break;
	case 'i': t.invert(); break;
	case 't':
		if (arg3(getopt.optarg, &x, &y, &z))
			goto usage;
		t.translate(x, y, z);
		break;
	case 'x':
		if (arg1(getopt.optarg, &a))
			goto usage;
		t.xRotate(deg_to_rad(a));
		break;
	case 'y':
		if (arg1(getopt.optarg, &a))
			goto usage;
		t.yRotate(deg_to_rad(a));
		break;
	case 'z':
		if (arg1(getopt.optarg, &a))
			goto usage;
		t.zRotate(deg_to_rad(a));
		break;
	case 'r':
		if (arg4(getopt.optarg, &x, &y, &z, &a))
			goto usage;
		t.rotate(x, y, z, deg_to_rad(a));
		break;
	case 'a':
		if (arg3(getopt.optarg, &p0.elem(0), &p0.elem(1), &p0.elem(2)))
			goto usage;
		cout << t.apply(p0) << endl;
		break;
	case 'A':
		if (arg6(getopt.optarg, &p0.elem(0), &p0.elem(1), &p0.elem(2),
					&p1.elem(0), &p1.elem(1), &p1.elem(2)))
			goto usage;
		t.setZAlign(p0, p1);
		break;
	case 'p': cout << t; break;
	case '.':
		{
			Geom3d::Xform t2(t);
			t2.invert();
			t2.multiply(t);
			cout << t2;
		}
		break;
	default:
		cerr << argv[0] << ": unknown op: '" << (char) c << "'\n";
		break;
	}
	if (argc != getopt.optind) {
usage:
		cerr << "usage: " << argv[0] << " op(s)\n";
		return 1;
	}
	return 0;
}
