#include "MEdge.h"
#include "MVertex.h"
#include "MGraph.h"
#include "common.h"
#include "alloc.h"
#include "misc.h"

MEdge::~MEdge(void)
{
	for (int end = 0; end < 2; end++) {
		MVertex	*v = Ends[end];
		int	*numEdges, edge;
		MEdge	**edges;

		if (v->Graph->beingDestroyed())
			continue;
			
		if (Pseudo) {
			numEdges = &v->NumPseudoEdges;
			edges = v->PseudoEdges;
		} else {
			numEdges = &v->NumEdges;
			edges = v->Edges;
		}
		for (edge = *numEdges; edge > 0; edge--)
			if (edges[edge] == (MEdge *) this)
				break;
		edges[edge] = edges[--(*numEdges)];

		if (end > 0 && Ends[0]->Graph == Ends[1]->Graph)
			continue;
		
		v->Graph->delEdge((MEdge *) this);
	}
	mg_free(Rings);
}

void MEdge::delRing(const MRing *r)
{
	for (int ir = NumRings - 1; ir >= 0; ir--) {
		if (Rings[ir] == r)
			break;
	}
	Rings[ir] = Rings[--NumRings];
	if (NumRings == 0)
		mg_free(Rings);
	
	Ends[0]->delRing(r);
	Ends[1]->delRing(r);
}

MEdge::MEdge(MVertex *v1, MVertex *v2, int pseudoType)
  // pseudoType defaults to -1
{
	MEdge::init(v1, v2, pseudoType);
}

MEdge::MEdge(MVertex *v[2], int pseudoType)
  // pseudoType defaults to -1
{
	MEdge::init(v[0], v[1], pseudoType);
}

void MEdge::init(MVertex *v1, MVertex *v2, int pseudoType) 
{
	if (v1 == v2) 
		mg_fatal("Attempt to form loop edge.");
	
	if (v1->Graph != v2->Graph && pseudoType < 0)
		mg_fatal("Cannot form standard edge joining two graphs.");
	
	if (v1->isConnectedTo(v2))
		mg_fatal("Attempt to form duplicate edge.");
	
	Ends[0] = v1, Ends[1] = v2;
	NumRings = 0;
	Rings = NULL;
	BreakPoint = NULL;

	Pseudo = pseudoType >= 0;
	PseudoType = pseudoType;

	if (Pseudo) {
		v1->PseudoEdges = (MEdge **)
		  mg_realloc((void *)v1->PseudoEdges,
		  (v1->NumPseudoEdges+1) * sizeof(MEdge *));
		v2->PseudoEdges = (MEdge **)
		  mg_realloc((void *)v2->PseudoEdges,
		  (v2->NumPseudoEdges+1) * sizeof(MEdge *));
		v1->PseudoEdges[v1->NumPseudoEdges++] = (MEdge *) this;
		v2->PseudoEdges[v2->NumPseudoEdges++] = (MEdge *) this;
		for (int end = 0; end < 2; end++) {
			if (end > 0 && Ends[0]->Graph == Ends[1]->Graph)
				continue;
			Ends[end]->Graph->addEdge((MEdge *) this);
		}
	} else {
		v1->Edges = (MEdge **) mg_realloc((void *)v1->Edges,
		  (v1->NumEdges + 1) * sizeof(MEdge *));
		v2->Edges = (MEdge **) mg_realloc((void *)v2->Edges,
		  (v2->NumEdges + 1) * sizeof(MEdge *));
		v1->Edges[v1->NumEdges++] = (MEdge *) this;
		v2->Edges[v2->NumEdges++] = (MEdge *) this;
		v1->Graph->addEdge((MEdge *) this);
	}
}

void MEdge::setBreakPoint(const MVertex *v)
{
	if (v != NULL && v != Ends[0] && v != Ends[1])
		mg_fatal("Cannot set breakpoint vertex in edge between two other vertices.");
		
	BreakPoint = v;
	if (!Pseudo)
		v->graph()->setRootsInvalid();
}

MEdge	*MEdge::from(void)
{
	if (Pseudo)
		return NULL;
	Ends[0]->graph()->validateRoots();
	return From;
}

MVertex *MEdge::otherVertex(const MVertex *v) const
{
	if (v == Ends[0])
		return Ends[1];
	else if (v == Ends[1])
		return Ends[0];
	else
		return (MVertex *) NULL; // raise exception when available
}
