#ifndef MEDGE_H
#define MEDGE_H

#include "common.h"

class MEdge {
	MVertex		*Ends[2]; // end points
	bool		Pseudo;		// is this a pseudo-edge?
	int			PseudoType;	// pseudo-edge class
	const MVertex	*BreakPoint;
	  // NULL if this edge can be crossed during traversals,
	  // otherwise set to one of the endpoints (that endpoint
	  // will not consider this edge during a traversal)
	MRing			**Rings;	// rings this edge is involved in
	int			NumRings;

	friend class MGraph;	
	MEdge			*From;
	union {
		// this union for scratch variables
		bool		Visited; 
		  // has this edge been visited during current traversal?
	};
	  
	friend class MRing;
	void			addRing(const MRing *r);
	void			delRing(const MRing *r);

	void			init(MVertex *v1, MVertex *v2, int pseudoType = -1);


public:
				MEdge(MVertex *v1, MVertex *v2, int pseudoType = -1);
				MEdge(MVertex *v[2], int pseudoType = -1);
	virtual		~MEdge(void);
	
	bool		isPseudo(void) const { return Pseudo; }
	int			pseudoType(void) const {
					return Pseudo ? PseudoType : -1;
				}
	
	MVertex		*const *vertices(void) const {
					return (MVertex *const *)Ends;
				}
	MVertex		*otherVertex(const MVertex *v) const;
				
	const MVertex	*getBreakPoint(void) const { return BreakPoint; }
	void			setBreakPoint(const MVertex *v);

	MEdge			*from(void);
};

#endif
