#include "MVertex.h"
#include "MEdge.h"
#include "MGraph.h"
#include "common.h"
#include "alloc.h"

MVertex::MVertex(MGraph *mg) : Graph(mg)
{
	Edges = (MEdge **) NULL;
	NumEdges = 0;
	PseudoEdges = (MEdge **) NULL;
	NumPseudoEdges = 0;
	NumRings = 0;
	Rings = NULL;
	Graph->addVertex((MVertex *)this);
}

MVertex::~MVertex(void)
{
	if (!Graph->beingDestroyed()) {
		while (NumEdges > 0)
			delete Edges[0];
		while (NumPseudoEdges > 0)
			delete PseudoEdges[0];
		Graph->delVertex((MVertex *)this);
	}

	// mg_free internally checks for NULL
	mg_free((void *)Edges);
	mg_free((void *)PseudoEdges);
	mg_free((void *)Rings);
}

void MVertex::delRing(const MRing *r)
{
	for (int ir = NumRings - 1; ir >= 0; ir--) {
		if (Rings[ir] == r)
			break;
	}
	Rings[ir] = Rings[--NumRings];
	if (NumRings == 0)
		mg_free(Rings);
}

MVertex *MVertex::root(void) {
	Graph->validateRoots();
	return Root;
}

MVertex *MVertex::from(void) {
	Graph->validateRoots();
	return From;
}

MEdge *MVertex::isConnectedTo(MVertex *other) const
{
	if (NumEdges == 0)
		return (MEdge *)NULL;
	// above test necessary since below loop *doesn't* short-circuit
	// if Edges is NULL
	for (MEdge **curEdge = Edges + NumEdges - 1; curEdge >= Edges;
	  curEdge--) {
		if ((*curEdge)->otherVertex(this) == other)
			return *curEdge;
	}
	return (MEdge *) NULL;
}


