#ifndef MVERTEX_H
#define MVERTEX_H

#include "common.h"

class MVertex {
	MEdge		**Edges;	// connected standard edges
	int		NumEdges;
	MEdge		**PseudoEdges;
	  // simple list of pseudoedges, necessary for destructor to work
	int		NumPseudoEdges;
	MGraph		*const Graph;
	MRing		**Rings;
	int		NumRings;

	friend class MGraph;
	enum { CheckedAsEndNode, InCurrentAggregate };
	union {
		// this union for scratch variables
		bool	Visited;
		  // has this node been visited during current traversal?
		bool	*AggregateInfo;
	};

	MVertex	*Root, *From;
	  // Root = corresponding root for traversal
	  // From = previous node in a traversal

	friend class MEdge;
	void		addRing(const MRing *r);
	void		delRing(const MRing *r);
	
public:
			MVertex(MGraph *mg);
			  // vertices always in exactly one graph
	virtual	~MVertex(void);
	
	MEdge		*const *edges(void) const
				{ return (MEdge *const *) Edges; }
	int		numEdges(void) const
				{ return NumEdges; }
				
	MGraph	*const graph(void) const
				{ return Graph; }
	
	MVertex	*root(void);
	MVertex	*from(void);
	MEdge		*isConnectedTo(MVertex *) const;
		// returns NULL if not connected
};

#endif
