#ifndef MOLEDGE_H
#define MOLEDGE_H

#include "common.h"

#include "MEdge.h"
#include <mol/Iter.h>

template <class UVertex, class UEdge, class UGraph, class URing>
class MolEdge : public MEdge {
	public:
		typedef struct { const MEdge *e; int curVertex; } VertexIterState;

	private:
#include "MolEdge.private.h"
public:
				MolEdge(MVertex *v1, MVertex *v2, int pseudoType = -1)
			 	 : MEdge(v1, v2, pseudoType) {}
	virtual		~MolEdge(void) {}
	
	bool		isPseudo(void) const { return MEdge::isPseudo(); }
	int			pseudoType(void) const { return MEdge::pseudoType(); }
	
	CIter<UVertex>	vertexIter(void) const {
					VertexIterState *vis = new VertexIterState;
					vis->e = (MEdge *) this;
					vis->curVertex = 0;
					CIter<UVertex> vi(nextVertex,
					  (UVertex *) vertices()[0], 1, endIter,
					  remainingVertices, vis, dupState);
					return vi;
				}
					
	UVertex		*vertex(int i) const {
					return (UVertex *) MEdge::vertices()[i];
				}
	UVertex		*otherVertex(const UVertex *v) const {
					return (UVertex *)
					  MEdge::otherVertex((const MVertex *) v);
				}
	
	const UVertex	*getBreakPoint(void) const {
					return (const UVertex *) MEdge::getBreakPoint();
				}
	void			setBreakPoint(const UVertex *v) {
					MEdge::setBreakPoint((const MVertex *) v);
				}

};
#endif
