#ifndef MOLGRAPH_H
#define MOLGRAPH_H

#include "common.h"
#include <mol/Iter.h>
#include "MGraph.h"

template <class UVertex, class UEdge, class UGraph, class URing>
class MolGraph : public MGraph {
	public:
		typedef struct {
			MGraph *g;
			int cur;
		} IterState;
		typedef struct {
			const MGraph *g;
			int type, cur;
		} PseudoEdgeIterState;
		typedef struct {
			MGraph::VertexGroupList *base, *current;
			UVertex **convertBuf;
			int groupSize;
			int *refcount;
			int remaining;
		} VertexGroupIterState;
		typedef struct {
			const MGraph *g;
			const RootInfo *ri;
			int cur;
		} TraversalState;

	private:
#include "MolGraph.private.h"
public:
				MolGraph(unsigned size = 7250) : MGraph(size) {};
	virtual		~MolGraph(void) {};
	
        CIter<UVertex>  vertexIter(void) const {
					IterState *is = new IterState;
					is->g = (MGraph *) this;
					is->cur = 0;
					CIter<UVertex> i(next, numVertices() > 0 ? 
					  (UVertex *) vertices()[0] : NULL,
					  numVertices() > 0, endIter,
					  numRemaining, is, dupIterState);
					return i;
				}

	CIter<UEdge>	edgeIter(void) const {
					IterState *is = new IterState;
					is->g = (MGraph *) this;
					is->cur = 0;
					CIter<UEdge> i(next, numEdges() > 0 ? 
					  (UEdge *) edges()[0] : NULL,
					  numEdges() > 0, endIter, numRemaining,
					  is, dupIterState);
					return i;
				}
				
	CIter<UEdge>	pseudoEdgeIter(int type) const {
					PseudoEdgeIterState *peis =
					  new PseudoEdgeIterState;
					peis->g = (MGraph *) this;
					peis->type = type;
					peis->cur = 0;
					CIter<UEdge> pei(nextPseudoEdge,
					  numPseudoEdges(type) > 0 ? (UEdge *)
					  pseudoEdges(type)[0] : NULL, 
					  numPseudoEdges(type) > 0, endIter,
					  numRemainingPseudoEdges, peis,
					  dupPseudoEdgeIterState);
					return pei;
				}

	CIter<UVertex*const*>	vertexGroupIter(int groupSize) const {
					VertexGroupIterState *is =
					  new VertexGroupIterState;
					is->current = is->base =
					  vertexAggregates(groupSize, &(is->remaining));
					is->groupSize = groupSize;
					is->refcount = new int;
					*(is->refcount) = 1;
					is->convertBuf = new UVertex *[groupSize];
					if (is->remaining > 0) {
						for (int p = groupSize-1;
						  p >= 0; p--) {
							is->convertBuf[p] =
							  (UVertex *) is->current->group[p];
						}
					}
					CIter<UVertex*const*> i(next, is->remaining > 0 ? 
					  (UVertex *const**) &is->convertBuf : NULL,
					  is->remaining > 0, endIter,
					  numRemaining, is, dupIterState);
					return i;
				}

	
	int			numPseudoTypes(void) {
					return MGraph::numPseudoTypes();
				}
				
	CIter<UVertex>	rootIter(void) {
					IterState *is = new IterState;
					is->g = (MGraph *) this;
					is->cur = numRoots() - 1;
					CIter<UVertex> i(nextRoot, numRoots() > 0 ? 
					  (UVertex *) roots()[is->cur].root : NULL,
					  numRoots() > 0, endIter,
					  numRemainingRoots, is, dupIterState);
					return i;
				}					
				
	CIter<UEdge>	traverseEdges(UVertex *root) {
					useAsRoot((MVertex *)root);
					int rt = numRoots();
					const RootInfo *ri = roots();
					while (--rt >= 0)
						if (ri[rt].root == (MVertex *)root)
							break;
					TraversalState *ts = new TraversalState;
					ts->g = (MGraph *) this;
					ts->ri = ri + rt;
					ts->cur = 0;
					CIter<UEdge> te(traverseNext,
					  ts->ri->size.numEdges > 0 ? (UEdge *)
					  edges()[ts->ri->edgeIndex] : NULL,
					  ts->ri->size.numEdges > 0, endTraversal,
					  remainingTraversal, ts, dupTraversalState);
					return te;
				}
				
	CIter<UVertex>	traverseVertices(UVertex *root) {
					useAsRoot((MVertex *)root);
					int rt = numRoots();
					const RootInfo *ri = roots();
					while (--rt >= 0)
						if (ri[rt].root == (MVertex *)root)
							break;
					TraversalState *ts = new TraversalState;
					ts->g = (MGraph *) this;
					ts->ri = ri + rt;
					ts->cur = 0;
					CIter<UVertex> tv(traverseNext,
					  ts->ri->size.numVertices > 0 ? (UVertex *)
					  vertices()[ts->ri->vertexIndex] : NULL,
					  ts->ri->size.numVertices > 0, endTraversal,
					  remainingTraversal, ts, dupTraversalState);
					return tv;
				}
};

#endif
