
static
void			next(CIter<UVertex> *iter) {
				IterState *is = (IterState *) iter->state();
				is->cur++;
				if (is->cur >= is->g->numVertices()) {
					iter->element(NULL, 0);
				} else {
					iter->element((UVertex *)
					  is->g->vertices()[is->cur], 1);
				}
			}
static 
unsigned int	numRemaining(const CIter<UVertex> *iter) {
				IterState *is = (IterState *) iter->state();
				// number remaining includes current vertex
				return (is->g->numVertices() - is->cur);
			}
static
void			dupIterState(CIter<UVertex> *iter) {
				IterState *newis = new IterState;
				*newis = *((IterState *) iter->state());
				iter->state(newis);
			}
static
void			endIter(CIter<UVertex> *iter) {
				delete iter->state();
			}
static
void			next(CIter<UEdge> *iter) {
				IterState *is = (IterState *) iter->state();
				is->cur++;
				if (is->cur >= is->g->numEdges()) {
					iter->element(NULL, 0);
				} else {
					iter->element((UEdge *)
					  is->g->edges()[is->cur], 1);
				}
			}
static 
unsigned int	numRemaining(const CIter<UEdge> *iter) {
				IterState *is = (IterState *) iter->state();
				// number remaining includes current vertex
				return (is->g->numEdges() - is->cur);
			}
static
void			dupIterState(CIter<UEdge> *iter) {
				IterState *newis = new IterState;
				*newis = *((IterState *) iter->state());
				iter->state(newis);
			}
static
void			endIter(CIter<UEdge> *iter) {
				delete iter->state();
			}
static
void			next(CIter<UVertex*const*> *iter) {
				VertexGroupIterState *is =
				  (VertexGroupIterState *) iter->state();
				is->remaining--;
				if (is->remaining < 1) {
					iter->element(NULL, 0);
				} else {
					is->current = is->current->next;
					for (int i = is->groupSize - 1;
					  i >= 0; i--)
						is->convertBuf[i] = (UVertex *)
						  is->current->group[i];
					iter->element((UVertex *const**)&is->convertBuf, 1);
				}
			}
static 
unsigned int	numRemaining(const CIter<UVertex*const*> *iter) {
				VertexGroupIterState *is =
				  (VertexGroupIterState *) iter->state();
				// number remaining includes current
				return (is->remaining);
			}
static
void			dupIterState(CIter<UVertex*const*> *iter) {
				VertexGroupIterState *newis =
				  new VertexGroupIterState;
				VertexGroupIterState *curis =
				  (VertexGroupIterState *) iter->state();
				(*(curis->refcount))++;
				*newis = *curis;
				iter->state(newis);
				iter->element((UVertex *const**)&newis->convertBuf, 1);
			}
static
void			endIter(CIter<UVertex*const*> *iter) {
				VertexGroupIterState *is =
				  (VertexGroupIterState *) iter->state();
				(*(is->refcount))--;
				if (*(is->refcount) == 0) {
					delete is->refcount;
					delete is->convertBuf;
					MGraph::VertexGroupList *next;
					for (MGraph::VertexGroupList *cur =
					  is->base; cur != NULL; cur = next) {
						next = cur->next;
						delete cur;
					}
				}
				delete iter->state();
			}
static
void			nextPseudoEdge(CIter<UEdge> *iter) {
				PseudoEdgeIterState *peis =
				  (PseudoEdgeIterState *) iter->state();
				peis->cur++;
				if (peis->cur >= peis->g
				  ->numPseudoEdges(peis->type)) {
					iter->element(NULL, 0);
				} else {
					iter->element((UEdge *)
					  peis->g->pseudoEdges(peis->type)
					  [peis->cur], 1);
				}
			}
static 
unsigned int	numRemainingPseudoEdges(const CIter<UEdge> *iter) {
				PseudoEdgeIterState *peis =
				  (PseudoEdgeIterState *) iter->state();
				// number remaining includes current vertex
				return (peis->g->numPseudoEdges(peis->type)
				  - peis->cur);
			}
static
void			dupPseudoEdgeIterState(CIter<UEdge> *iter) {
				PseudoEdgeIterState *newpeis =
				  new PseudoEdgeIterState;
				*newpeis = *((PseudoEdgeIterState *)
				  iter->state());
				iter->state(newpeis);
			}
static
void			nextRoot(CIter<UVertex> *iter) {
				IterState *is = (IterState *) iter->state();
				is->cur--;
				if (is->cur < 0) {
					iter->element(NULL, 0);
				} else {
					iter->element((UVertex *)
					  ((MolGraph<UVertex,UEdge,UGraph,URing> *)is->g)->roots()[is->cur].root, 1);
				}
			}
static 
unsigned int	numRemainingRoots(const CIter<UVertex> *iter) {
				IterState *is = (IterState *) iter->state();
				// number remaining includes current root
				return (is->cur + 1);
			}
static
void			traverseNext(CIter<UEdge> *iter) {
				TraversalState *ts = (TraversalState *)
				  iter->state();
				ts->cur++;
				if (ts->cur >= ts->ri->size.numEdges) {
					iter->element(NULL, 0);
				} else {
					iter->element((UEdge *) ts->g->edges()
					  [ts->ri->edgeIndex + ts->cur], 1);
				}
			}
static
void			traverseNext(CIter<UVertex> *iter) {
				TraversalState *ts = (TraversalState *)
				  iter->state();
				ts->cur++;
				if (ts->cur >= ts->ri->size.numVertices) {
					iter->element(NULL, 0);
				} else {
					iter->element((UVertex *) ts->g->vertices()
					  [ts->ri->vertexIndex + ts->cur], 1);
				}
			}
static
void			endTraversal(CIter<UEdge> *iter) {
				delete iter->state();
			}
static
void			endTraversal(CIter<UVertex> *iter) {
				delete iter->state();
			}
static 
unsigned int	remainingTraversal(const CIter<UEdge> *iter) {
				TraversalState *ts = (TraversalState *)
				  iter->state();
				// number remaining includes current edge
				return (ts->ri->size.numEdges - ts->cur);
			}
static 
unsigned int	remainingTraversal(const CIter<UVertex> *iter) {
				TraversalState *ts = (TraversalState *)
				  iter->state();
				// number remaining includes current vertex
				return (ts->ri->size.numVertices - ts->cur);
			}
static
void			dupTraversalState(CIter<UEdge> *iter) {
				TraversalState *newts = new TraversalState;
				*newts = *((TraversalState *) iter->state());
				iter->state(newts);
			}
static
void			dupTraversalState(CIter<UVertex> *iter) {
				TraversalState *newts = new TraversalState;
				*newts = *((TraversalState *) iter->state());
				iter->state(newts);
			}
