#ifndef MOLVERTEX_H
#define MOLVERTEX_H

#include "common.h"

#include "MVertex.h"
#include <mol/Iter.h>

template <class UVertex, class UEdge, class UGraph, class URing>
class MolVertex : public MVertex {
public:
	typedef struct { const MVertex *v; int curEdge; } EdgeIterState;

private:
#include "MolVertex.private.h"

public:
				MolVertex(MGraph *mg) : MVertex(mg) {};
	virtual		~MolVertex(void) {};
	
	CIter<UEdge>	edgeIter(void) const {
					EdgeIterState *eis = new EdgeIterState;
					eis->v = (MVertex *) this;
					eis->curEdge = 0;
					CIter<UEdge> ei(nextEdge, numEdges() > 0 ? 
					  (UEdge *) edges()[0] : NULL, numEdges() > 0,
					  endIter, remainingEdges, eis, dupState);
					return ei;
				}
	
	UGraph		*const graph(void) const {
					return (UGraph *const) MVertex::graph();
				}
	
	UVertex		*root(void) {
					return (UVertex *) MVertex::root();
				}
	UVertex		*from(void) {
					return (UVertex *) MVertex::from();
				}
	UVertex		*isConnectedTo(UVertex *other) const {
					return (UVertex *)MVertex::isConnectedTo((MVertex *)other);
				}
};

#endif
