#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

// memory allocation routines for MolGraph classes.
// 	They all exit on error with underlying system memory allocation
//	routines.  Malloc returns nil pointer on request for zero bytes.
//	Realloc calls malloc when given a nil pointer.

void *
mg_malloc(unsigned size)
{
        register void   *cp;

	if (size == 0)
		return NULL;
        if ((cp = (void *)malloc(size)) == NULL) {
                fprintf(stderr, "mg_malloc(%u) failed\n", size);
                exit(1);
        }
        return cp;
}

void *
mg_realloc(void *ptr, unsigned size)
{
        register void   *cp;

	if (ptr == NULL)
		return mg_malloc(size);
        if ((cp = (void *)realloc(ptr, size)) == NULL) {
                fprintf(stderr, "mg_realloc(ptr, %u) failed\n", size);
                exit(1);
        }
        return cp;
}

void *
mg_calloc(unsigned nelem, unsigned elsize)
{
        register void   *cp;

	if (nelem == 0)
		return NULL;
        if ((cp = (void *)calloc(nelem, elsize)) == NULL) {
                fprintf(stderr, "mg_calloc(%u, %u) failed\n", nelem, elsize);
                exit(1);
        }
        return cp;
}

void
mg_free(void *ptr)
{
	if (ptr != NULL)
		(void) free(ptr);
}
