//
//	Copyright (c) 1992 The Regents of the University of California.
//	All rights reserved.
//
//	Redistribution and use in source and binary forms are permitted
//	provided that the above copyright notice and this paragraph are
//	duplicated in all such forms and that any documentation,
//	advertising materials, and other materials related to such
//	distribution and use acknowledge that the software was developed
//	by the University of California, San Francisco.  The name of the
//	University may not be used to endorse or promote products derived
//	from this software without specific prior written permission.
//	THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
//	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
//	WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
//	$Id: pdb_type.cc,v 1.6 94/01/26 18:17:10 gregc Exp $
//
//	subroutine for reading PDB format files
//

# include	"pdb++.h"
extern "C" {
# include	<ctype.h>
# include	<string.h>
}

# ifndef _toupper
# define	_toupper	toupper
# endif

PDB::RecordType
PDB::getType(const char *buf)
{
	char	rt[4];		// PDB record type
	int	i;

	for (i = 0; buf[i] != '\0' && buf[i] != '\n' && i < 4; i += 1) {
		if (islower(buf[i]))
			rt[i] = _toupper(buf[i]);
		else
			rt[i] = buf[i];
	}
	if (i < 4)
		for (; i < 4; i += 1)
			rt[i] = ' ';

	switch (rt[0]) {

	case 'A':
		switch (rt[1]) {
		case 'G':
			if (rt[2] == 'R' && rt[3] == 'D')
				return AGRDES;
			if (rt[2] == 'G' && rt[3] == 'R')
				return AGGRGT;
			break;
		case 'N':
			if (rt[2] == 'I' && rt[3] == 'S')
				return ANISOU;
			break;
		case 'T':
			if (rt[2] == 'O' && rt[3] == 'M')
				return ATOM;
			break;
		case 'U':
			if (rt[2] == 'T' && rt[3] == 'H')
				return AUTHOR;
			break;
		}
		break;

	case 'C':
		switch (rt[1]) {
		case 'M':
			if (rt[2] == 'P' && rt[3] == 'D')
				return CMPDES;
			if (rt[2] == 'P' && rt[3] == 'O')
				return CMPONT;
			break;
		case 'O':
			if (rt[2] == 'M' && rt[3] == 'P')
				return COMPND;
			if (rt[2] == 'N' && rt[3] == 'E')
				return CONECT;
			break;
		case 'R':
			if (rt[2] == 'Y' && rt[3] == 'S')
				return CRYST1;
			break;
		}
		break;

	case 'E':
		switch (rt[1]) {
		case 'N':
			if (rt[2] == 'D' && rt[3] == ' ')
				return END;
			if (rt[2] == 'D' && rt[3] == 'M')
				return ENDMDL;
			break;
		case 'X':
			if (rt[2] == 'P' && rt[3] == 'D')
				return EXPDTA;
			break;
		}
		break;

	case 'F':
		switch (rt[1]) {
		case 'T':
			if (rt[2] == 'N' && rt[3] == 'O')
				return FTNOTE;
			break;
		case 'O':
			if (rt[2] == 'R' && rt[3] == 'M')
				return FORMUL;
			break;
		}
		break;

	case 'H':
		if (rt[1] != 'E')
			break;
		if (rt[2] == 'T' && rt[3] == 'A')
			return HETATM;
		if (rt[2] == 'A' && rt[3] == 'D')
			return HEADER;
		if (rt[2] == 'T' && rt[3] == ' ')
			return HET;
		if (rt[2] == 'L' && rt[3] == 'I')
			return HELIX;
		break;

	case 'J':
		if (rt[1] == 'R' && rt[2] == 'N' && rt[3] == 'L')
			return JRNL;
		break;

	case 'M':
		switch (rt[1]) {
		case 'A':
			if (rt[2] == 'S' && rt[3] == 'T')
				return MASTER;
			break;
		case 'O':
			if (rt[2] == 'D' && rt[3] == 'E')
				return MODEL;
			break;
		case 'T':
			if (rt[2] == 'R' && rt[3] == 'I')
				return MTRIX;
			if (rt[2] == 'X' && rt[3] == 'D')
				return MTXDES;
			break;
		}
		break;

	case 'O':
		switch (rt[1]) {
		case 'B':
			if (rt[2] == 'S' && rt[3] == 'L')
				return OBSLTE;
			break;
		case 'R':
			if (rt[2] == 'I' && rt[3] == 'G')
				return ORIGX;
			break;
		}
		break;

	case 'R':
		if (rt[1] != 'E')
			break;
		if (rt[2] == 'M' && rt[3] == 'A')
			return REMARK;
		if (rt[2] == 'V' && rt[3] == 'D')
			return REVDAT;
		break;

	case 'S':
		switch (rt[1]) {

		case 'C':
			if (rt[2] == 'A' && rt[3] == 'L')
				return SCALE;
			break;

		case 'E':
			if (rt[2] == 'Q' && rt[3] == 'R')
				return SEQRES;
			break;

		case 'H':
			if (rt[2] == 'E' && rt[3] == 'E')
				return SHEET;
			break;

		case 'I':
			if (rt[2] == 'T' && rt[3] == 'E')
				return SITE;
			if (rt[2] == 'G' && rt[3] == 'A')
				return SIGATM;
			if (rt[2] == 'G' && rt[3] == 'U')
				return SIGUIJ;
			break;

		case 'O':
			if (rt[2] == 'U' && rt[3] == 'R')
				return SOURCE;
			break;

		case 'P':
			if (rt[2] == 'R' && rt[3] == 'S')
				return SPRSDE;
			break;

		case 'S':
			if (rt[2] == 'B' && rt[3] == 'O')
				return SSBOND;
			break;

		case 'Y':
			if (rt[2] == 'M' && rt[3] == 'D')
				return SYMDES;
			if (rt[2] == 'M' && rt[3] == 'O')
				return SYMOP;
			break;
		}
		break;

	case 'T':
		switch (rt[1]) {
		case 'E':
			if (rt[2] == 'R' && rt[3] == ' ')
				return TER;
			break;
		case 'R':
			if (rt[2] == 'N' && rt[3] == 'S')
				return TRNSFM;
			break;
		case 'U':
			if (rt[2] == 'R' && rt[3] == 'N')
				return TURN;
			break;
		case 'V':
			if (rt[2] == 'E' && rt[3] == 'C')
				return TVECT;
			break;
		}
		break;

	case 'U':
		if (rt[1] == 'S' && rt[2] == 'E' && rt[3] == 'R')
			return USER;
		break;
	}
	return UNKNOWN;
}
