// Copyright 1992, U.C.S.F. Computer Graphics Laboratory
// $Id: PDBio.h,v 1.13 1994/09/28 18:47:07 gregc Exp $

#ifndef PDBio_h
#define	PDBio_h

#include <pdb++.h>
#include <strstream.h>
#include <BitSet.h>
#include <SLList.h>
#include "int.VoidP.Map.h"
#include "VoidP.int.Map.h"

extern void	PDBioCanonicalizeAtomName(String *aname);
extern void	PDBioCanonicalizeResidueName(String *aname);
extern float	PDBioTolerance;		// want as a static var in class PDBio

template <class Bond, class Atom, class Residue, class Coord, class CoordSet, class Molecule>
class PDBio {
protected:
	ostrstream	ioErr;
	SLList<Molecule *>
			ml;
	BitSet		what;
	BitSet		rMask, wMask;
	bool		(*rFunc)(PDB *, Molecule *, const intVoidPMap *),
			(*wFunc)(ostream *, PDB *, Molecule *, Atom *,
							const VoidPintMap *);

	static void	addBond(intVoidPMap *, int, int);
	static void	addBondToNamed(Atom *, Residue *, const Symbol &);
	static bool	addBondIfClose(Atom *, Atom *);
	static Atom	*findClosest(Atom *, Residue *, float *);
	static void	addBondNearestPair(Residue *, Residue *);
	bool		readOneMolecule(istream *, Molecule *, const char *,
							int *, void *, void *);
	static void	connectMolecule(Molecule *, void *, void *);
public:
	static float	bondLengthTolerance() { return PDBioTolerance; }
	static void	bondLengthTolerance(float t) { PDBioTolerance = t; };
	enum {
		ATOMS, COVALENT_BONDS, HYDROGEN_BONDS, SALT_BRIDGES,
		COMMENTS, MULTIPLE_MODELS
	};
			PDBio(): rFunc(0), wFunc(0) {
				what.set(ATOMS);
				what.set(COVALENT_BONDS);
			}
			PDBio(const BitSet &w): what(w), rFunc(0), wFunc(0) {}
			PDBio(const BitSet &w, const BitSet &rm, const BitSet &wm):
				what(w), rMask(rm), wMask(wm), rFunc(0),
				wFunc(0) {}
	virtual		~PDBio(void) {}
	int		readPDBstream(istream *, const char *, int);
	void		readPDBfile(const char *filename);
	void		writePDBstream(ostream *, const char *filename);
	void		writePDBfile(const char *filename);
	bool		ok(void) { return ioErr.pcount() == 0; }
	const char	*error(void) { return ioErr.str(); }
	Molecule	*molecule() { return ml.front(); }
	void		molecule(Molecule *mol) { ml.clear(); ml.append(mol); }
	SLList<Molecule *>
			molecules() const { return ml; }
	void		molecules(SLList<Molecule *> mols) { ml = mols; }
	BitSet		&whatToDo() { return what; }
	BitSet		&readMask() { return rMask; }
	void		readPDB(bool (*r)(PDB *, Molecule *, const intVoidPMap *))
				{ rFunc = r; }
	bool		(*readPDB())(PDB *, Molecule *, const intVoidPMap *)
				{ return rFunc; }
	BitSet		&writeMask() { return wMask; }
	void		writePDB(bool (*w)(ostream *, PDB *, Molecule *, Atom *, const VoidPintMap *))
				{ wFunc = w; }
	bool		(*writePDB())(ostream *, PDB *, Molecule *, Atom *, const VoidPintMap *)
				{ return wFunc; }
};

#include "PDBio.cc"

#endif
