// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _SymbolVoidPMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _SymbolVoidPMap_h 1

#include <Pix.h>
#include "mol/Symbol.defs.h"
#include "VoidP.defs.h"

class SymbolVoidPMap
{
protected:
  int                   count;
  VoidP                   def;

public:
                        SymbolVoidPMap(VoidP  dflt);
  virtual              ~SymbolVoidPMap();

  int                   length() const;		// current number of items
  int                   empty() const;

  virtual int           contains(const Symbol& key) const;	// is key mapped?

  virtual void          clear();                 // delete all items

  virtual VoidP&          operator [] (const Symbol& key) = 0; // access contents by key

  virtual void          del(const Symbol& key) = 0;       // delete entry

  virtual Pix           first() const = 0;		// Pix of first item or 0
  virtual void          next(Pix& i) const = 0;		// advance to next or 0
  virtual const Symbol&	key(Pix i) const = 0;		// access key at i
  virtual VoidP&          contents(Pix i) const = 0;	// access contents at i

  virtual int           owns(Pix i) const;		// is i a valid Pix  ?
  virtual Pix           seek(const Symbol& key) const;	// Pix of key

  VoidP&		dflt();				// access default val

  void                  error(const char* msg) const;
  virtual int           OK() = 0;                // rep invariant
};


inline SymbolVoidPMap::~SymbolVoidPMap() {}

inline int SymbolVoidPMap::length() const
{
  return count;
}

inline int SymbolVoidPMap::empty() const
{
  return count == 0;
}

inline VoidP& SymbolVoidPMap::dflt()
{
  return def;
}

inline SymbolVoidPMap::SymbolVoidPMap(VoidP  dflt) :def(dflt)
{
  count = 0;
}

#endif
