// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _SymbolVoidPVHMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _SymbolVoidPVHMap_h 1

#include "Symbol.VoidP.Map.h"


class SymbolVoidPVHMap : public SymbolVoidPMap
{
protected:
  Symbol*           tab;
  VoidP*           cont;
  char*          status;
  unsigned int   size;

public:
                SymbolVoidPVHMap(VoidP  dflt,unsigned int sz=DEFAULT_INITIAL_CAPACITY);
                SymbolVoidPVHMap(SymbolVoidPVHMap& a);
                ~SymbolVoidPVHMap();

  VoidP&          operator [] (const Symbol& key);

  void          del(const Symbol& key);

  Pix           first() const;
  void          next(Pix& i) const;
  const Symbol&          key(Pix i) const;
  VoidP&          contents(Pix i) const;

  Pix           seek(const Symbol& key) const;
  int           contains(const Symbol& key) const;

  void          clear(); 
  void          resize(unsigned int newsize = 0);

  int           OK();
};

inline SymbolVoidPVHMap::~SymbolVoidPVHMap()
{
  delete [] tab;
  delete [] cont;
  delete [] status;
}

inline int SymbolVoidPVHMap::contains(const Symbol& key) const
{
  return seek(key) != 0;
}

inline const Symbol& SymbolVoidPVHMap::key(Pix i) const
{
  if (i == 0) error("null Pix");
  return *((Symbol*)i);
}

inline VoidP& SymbolVoidPVHMap::contents(Pix i) const
{
  if (i == 0) error("null Pix");
  return cont[((unsigned)(i) - (unsigned)(tab)) / sizeof(Symbol)];
}

#endif
