// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _VoidPCHSet_h
#ifdef __GNUG__
#pragma interface
#endif
#define _VoidPCHSet_h 1

#include "VoidP.Set.h"
#include "VoidP.CHNode.h"

class VoidPCHSet : public VoidPSet
{
protected:
  VoidPCHNode**   tab;
  unsigned int  size;

public:
                VoidPCHSet(unsigned int sz = DEFAULT_INITIAL_CAPACITY);
                VoidPCHSet(const VoidPCHSet& a);
                ~VoidPCHSet();

  Pix           add(VoidP  item);
  void          del(VoidP  item);
  int           contains(VoidP  item) const;

  void          clear();

  Pix           first() const;
  void          next(Pix& i) const;
  VoidP&          operator () (Pix i) const;
  Pix           seek(VoidP  item) const;

  void          operator |= (VoidPCHSet& b);
  void          operator -= (VoidPCHSet& b);
  void          operator &= (VoidPCHSet& b);

  int           operator == (const VoidPCHSet& b) const;
  int           operator != (const VoidPCHSet& b) const;
  int           operator <= (const VoidPCHSet& b) const;

  int           OK();
};

inline VoidPCHSet::~VoidPCHSet()
{
  clear();
  delete tab;
}

inline int VoidPCHSet::contains(VoidP  key) const
{
  return seek(key) != 0;
}

inline VoidP& VoidPCHSet::operator () (Pix i) const
{
  if (i == 0) error("null Pix");
  return ((VoidPCHNode*)i)->hd;
}

inline int VoidPCHSet::operator != (const VoidPCHSet& b) const
{
  return ! ((*this) == b);
}

#endif
