// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _VoidPSet_h
#ifdef __GNUG__
#pragma interface
#endif
#define _VoidPSet_h 1

#include <Pix.h>
#include "VoidP.defs.h"

class VoidPSet
{
protected:

  int                   count;

public:
  virtual              ~VoidPSet();

  int                   length();                // current number of items
  int                   empty();

  virtual Pix           add(VoidP  item) = 0;      // add item; return Pix
  virtual void          del(VoidP  item) = 0;      // delete item
  virtual int           contains(VoidP  item) const;     // is item in set?

  virtual void          clear();                 // delete all items

  virtual Pix           first() const = 0;             // Pix of first item or 0
  virtual void          next(Pix& i) const = 0;        // advance to next or 0
  virtual VoidP&          operator () (Pix i) const = 0; // access item at i

  virtual int           owns(Pix i) const;             // is i a valid Pix  ?
  virtual Pix           seek(VoidP  item) const;         // Pix of item

  void                  operator |= (VoidPSet& b); // add all items in b
  void                  operator -= (VoidPSet& b); // delete items also in b
  void                  operator &= (VoidPSet& b); // delete items not in b

  int                   operator == (const VoidPSet& b) const;
  int                   operator != (const VoidPSet& b) const;
  int                   operator <= (const VoidPSet& b) const; 

  void                  error(const char* msg) const;
  virtual int           OK() = 0;                // rep invariant
};

inline VoidPSet::~VoidPSet() {}

inline int VoidPSet::length()
{
  return count;
}

inline int VoidPSet::empty()
{
  return count == 0;
}

#endif
