// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _VoidPintVHMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _VoidPintVHMap_h 1

#include "VoidP.int.Map.h"


class VoidPintVHMap : public VoidPintMap
{
protected:
  VoidP*	 tab;
  int*		 cont;
  char*		 status;
  unsigned int	 size;

public:
		VoidPintVHMap(int dflt,unsigned int sz=DEFAULT_INITIAL_CAPACITY);
		VoidPintVHMap(VoidPintVHMap& a);
		~VoidPintVHMap();

  int&		operator [] (VoidP key);
  int		operator [] (VoidP key) const;

  void		del(VoidP key);

  Pix		first() const;
  void		next(Pix& i) const;
  VoidP		key(Pix i) const;
  int&		contents(Pix i);
  int		contents(Pix i) const;

  Pix		seek(VoidP key) const;
  int		contains(VoidP key) const;

  void		clear(); 
  void		resize(unsigned int newsize = 0);

  int		OK() const;
};

inline VoidPintVHMap::~VoidPintVHMap()
{
  delete [] tab;
  delete [] cont;
  delete [] status;
}

inline int VoidPintVHMap::contains(VoidP key) const
{
  return seek(key) != 0;
}

inline VoidP VoidPintVHMap::key(Pix i) const
{
  if (i == 0) error("null Pix");
  return *((VoidP*)i);
}

inline int& VoidPintVHMap::contents(Pix i)
{
  if (i == 0) error("null Pix");
  return cont[((unsigned)(i) - (unsigned)(tab)) / sizeof(VoidP)];
}

inline int VoidPintVHMap::contents(Pix i) const
{
  if (i == 0) error("null Pix");
  return cont[((unsigned)(i) - (unsigned)(tab)) / sizeof(VoidP)];
}

#endif
