// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef __GNUG__
#pragma implementation
#endif
#include "int.VoidP.CHMap.h"

// The nodes are linked together serially via a version
// of a trick used in some vtables: odd pointers are
// actually links to the next table entry. 
// Not terrible, but not wonderful either

static inline int goodCHptr(intVoidPCHNode* t)
{
  return ((((unsigned)t) & 1) == 0);
}

static inline intVoidPCHNode* index_to_CHptr(int i)
{
  return (intVoidPCHNode*)((i << 1) + 1);
}

static inline int CHptr_to_index(intVoidPCHNode* t)
{
  return ( ((unsigned) t) >> 1);
}

intVoidPCHMap::intVoidPCHMap(VoidP dflt, unsigned int sz)
     :intVoidPMap(dflt)
{
  tab = (intVoidPCHNode**)(new intVoidPCHNodePtr[size = sz]);
  for (unsigned int i = 0; i < size; ++i) tab[i] = index_to_CHptr(i+1);
  count = 0;
}

intVoidPCHMap::intVoidPCHMap(intVoidPCHMap& a) :intVoidPMap(a.def)
{
  tab = (intVoidPCHNode**)(new intVoidPCHNodePtr[size = a.size]);
  for (unsigned int i = 0; i < size; ++i) tab[i] = index_to_CHptr(i+1);
  count = 0;
  for (Pix p = a.first(); p; a.next(p)) (*this)[a.key(p)] = a.contents(p);
}


Pix intVoidPCHMap::seek(int key) const
{
  unsigned int h = intHASH(key) % size;

  for (intVoidPCHNode* t = tab[h]; goodCHptr(t); t = t->tl)
    if (intEQ(key, t->hd))
      return Pix(t);

  return 0;
}


VoidP& intVoidPCHMap::operator [](int item)
{
  unsigned int h = intHASH(item) % size;

  for (intVoidPCHNode* t = tab[h]; goodCHptr(t); t = t->tl)
    if (intEQ(item, t->hd))
      return t->cont;

  t = new intVoidPCHNode(item, def, tab[h]);
  tab[h] = t;
  ++count;
  return t->cont;
}


VoidP intVoidPCHMap::operator [](int item) const
{
  unsigned int h = intHASH(item) % size;

  for (intVoidPCHNode* t = tab[h]; goodCHptr(t); t = t->tl)
    if (intEQ(item, t->hd))
      return t->cont;

  return def;
}


void intVoidPCHMap::del(int key)
{
  unsigned int h = intHASH(key) % size;

  intVoidPCHNode* t = tab[h]; 
  intVoidPCHNode* trail = t;
  while (goodCHptr(t))
  {
    if (intEQ(key, t->hd))
    {
      if (trail == t)
	tab[h] = t->tl;
      else
	trail->tl = t->tl;
      delete t;
      --count;
      return;
    }
    trail = t;
    t = t->tl;
  }
}


void intVoidPCHMap::clear()
{
  for (unsigned int i = 0; i < size; ++i)
  {
    intVoidPCHNode* p = tab[i];
    tab[i] = index_to_CHptr(i+1);
    while (goodCHptr(p))
    {
      intVoidPCHNode* nxt = p->tl;
      delete(p);
      p = nxt;
    }
  }
  count = 0;
}

Pix intVoidPCHMap::first() const
{
  for (unsigned int i = 0; i < size; ++i) if (goodCHptr(tab[i])) return Pix(tab[i]);
  return 0;
}

void intVoidPCHMap::next(Pix& p) const
{
  intVoidPCHNode* t = ((intVoidPCHNode*)p)->tl;
  if (goodCHptr(t))
    p = Pix(t);
  else
  {
    for (unsigned int i = CHptr_to_index(t); i < size; ++i) 
    {
      if (goodCHptr(tab[i]))
      {
	p =  Pix(tab[i]);
	return;
      }
    }
    p = 0;
  }
}


int intVoidPCHMap::OK() const
{
  int v = tab != 0;
  int n = 0;
  for (unsigned int i = 0; i < size; ++i)
  {
    for (intVoidPCHNode* p = tab[i]; goodCHptr(p); p = p->tl) ++n;
    v &= CHptr_to_index(p) == i + 1;
  }
  v &= count == n;
  if (!v) error("invariant failure");
  return v;
}
