// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _intVoidPCHMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _intVoidPCHMap_h 1

#include "int.VoidP.Map.h"

#ifndef _intVoidPCHNode_h
#define _intVoidPCHNode_h 1

struct intVoidPCHNode
{
  intVoidPCHNode*	tl;
  int			hd;
  VoidP			cont;
			intVoidPCHNode();
			intVoidPCHNode(int h, VoidP c, intVoidPCHNode* t = 0);
			~intVoidPCHNode();
};

inline intVoidPCHNode::intVoidPCHNode() {}

inline intVoidPCHNode::intVoidPCHNode(int h, VoidP c, intVoidPCHNode* t)
     : tl(t), hd(h), cont(c) {}

inline intVoidPCHNode::~intVoidPCHNode() {}

typedef intVoidPCHNode* intVoidPCHNodePtr;

#endif


class intVoidPCHMap : public intVoidPMap
{
protected:
  intVoidPCHNode** tab;
  unsigned int	 size;

public:
		intVoidPCHMap(VoidP dflt,unsigned int sz=DEFAULT_INITIAL_CAPACITY);
		intVoidPCHMap(intVoidPCHMap& a);
		~intVoidPCHMap();

  VoidP&	operator [] (int key);
  VoidP		operator [] (int key) const;

  void		del(int key);

  Pix		first() const;
  void		next(Pix& i) const;
  const int	key(Pix i) const;
  VoidP&	contents(Pix i);
  VoidP		contents(Pix i) const;

  Pix		seek(int key) const;
  int		contains(int key) const;

  void		clear(); 
  int		OK() const;
};


inline intVoidPCHMap::~intVoidPCHMap()
{
  clear();
  delete tab;
}

inline int intVoidPCHMap::contains(int key) const
{
  return seek(key) != 0;
}

inline const int intVoidPCHMap::key(Pix p) const
{
  if (p == 0) error("null Pix");
  return ((intVoidPCHNode*)p)->hd;
}

inline VoidP& intVoidPCHMap::contents(Pix p)
{
  if (p == 0) error("null Pix");
  return ((intVoidPCHNode*)p)->cont;
}

inline VoidP intVoidPCHMap::contents(Pix p) const
{
  if (p == 0) error("null Pix");
  return ((intVoidPCHNode*)p)->cont;
}

#endif
