// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _intVoidPMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _intVoidPMap_h 1

#include <Pix.h>
#include "int.defs.h"

typedef void	*VoidP;

class intVoidPMap
{
protected:
  int			count;
  VoidP			  def;

public:
			intVoidPMap(VoidP  dflt);
  virtual	       ~intVoidPMap();

  int			length() const;		// current number of items
  int			empty() const;

  virtual int		contains(int key) const;	// is key mapped?

  virtual void		clear();		// delete all items

  virtual VoidP&	operator [] (int key) = 0; // access contents by key
  virtual VoidP		operator [] (int key) const = 0; // access contents by key

  virtual void		del(int	key) = 0;	// delete entry

  virtual Pix		first() const = 0;	// Pix of first item or 0
  virtual void		next(Pix& i) const = 0;	// advance to next or 0
  virtual const int	key(Pix i) const = 0;	// access key at i
  virtual VoidP&	contents(Pix i) = 0;	// access contents at i
  virtual VoidP		contents(Pix i) const = 0;	// access contents at i

  virtual int		owns(Pix i) const;	// is i a valid Pix  ?
  virtual Pix		seek(int key) const;	// Pix of key

  VoidP&		dflt();		   // access default val

  void			error(const char* msg) const;
  virtual int		OK() const = 0;		 // rep invariant
};


inline intVoidPMap::~intVoidPMap() {}

inline int intVoidPMap::length() const
{
  return count;
}

inline int intVoidPMap::empty() const
{
  return count == 0;
}

inline VoidP& intVoidPMap::dflt()
{
  return def;
}

inline intVoidPMap::intVoidPMap(VoidP  dflt) :def(dflt)
{
  count = 0;
}

#endif
