#include <stdio.h>

typedef struct {
	char	*type1;
	char	*type2;
	float	db;
	float	r0;
	char	*desc;
} bondParam;

bondParam bond_params[] = {
#if 1
	/* amber */
	{ "HW", "OW", 553.000000, 0.957200, "" },
	{ "HW", "HW", 553.000000, 1.513600, "" },
	{ "C*", "HC", 340.000000, 1.080000, "" },
	{ "C", "C2", 317.000000, 1.522000, "" },
	{ "C", "C3", 317.000000, 1.522000, "" },
	{ "C", "CA", 469.000000, 1.400000, "" },
	{ "C", "CB", 447.000000, 1.419000, "" },
	{ "C", "CD", 469.000000, 1.400000, "" },
	{ "C", "CH", 317.000000, 1.522000, "" },
	{ "C", "CJ", 410.000000, 1.444000, "" },
	{ "C", "CM", 410.000000, 1.444000, "" },
	{ "C", "CT", 317.000000, 1.522000, "" },
	{ "C", "N", 490.000000, 1.335000, "" },
	{ "C", "N*", 424.000000, 1.383000, "" },
	{ "C", "NA", 418.000000, 1.388000, "" },
	{ "C", "NC", 457.000000, 1.358000, "" },
	{ "C", "O", 570.000000, 1.229000, "" },
	{ "C", "O2", 656.000000, 1.250000, "" },
	{ "C", "OH", 450.000000, 1.364000, "" },
	{ "C*", "C2", 317.000000, 1.495000, "" },
	{ "C*", "CB", 388.000000, 1.459000, "" },
	{ "C*", "CG", 546.000000, 1.352000, "" },
	{ "C*", "CT", 317.000000, 1.495000, "" },
	{ "C*", "CW", 546.000000, 1.352000, "" },
	{ "C2", "C2", 260.000000, 1.526000, "" },
	{ "C2", "C3", 260.000000, 1.526000, "" },
	{ "C2", "CA", 317.000000, 1.510000, "" },
	{ "C2", "CC", 317.000000, 1.504000, "" },
	{ "C2", "CH", 260.000000, 1.526000, "" },
	{ "C2", "N", 337.000000, 1.449000, "" },
	{ "C2", "N2", 337.000000, 1.463000, "" },
	{ "C2", "N3", 367.000000, 1.471000, "" },
	{ "CH", "N3", 367.000000, 1.471000, "" },
	{ "C2", "NT", 367.000000, 1.471000, "" },
	{ "C2", "OH", 386.000000, 1.425000, "" },
	{ "C2", "OS", 320.000000, 1.425000, "" },
	{ "C2", "S", 222.000000, 1.810000, "" },
	{ "C2", "SH", 222.000000, 1.810000, "" },
	{ "C3", "CH", 260.000000, 1.526000, "" },
	{ "C3", "CM", 317.000000, 1.510000, "" },
	{ "C3", "N", 337.000000, 1.449000, "" },
	{ "C3", "N*", 337.000000, 1.475000, "" },
	{ "C3", "N2", 337.000000, 1.463000, "" },
	{ "C3", "N3", 367.000000, 1.471000, "" },
	{ "C3", "OH", 386.000000, 1.425000, "" },
	{ "C3", "OS", 320.000000, 1.425000, "" },
	{ "C3", "S", 222.000000, 1.810000, "" },
	{ "C3", "SH", 222.000000, 1.810000, "" },
	{ "CA", "CA", 469.000000, 1.400000, "" },
	{ "CA", "CB", 469.000000, 1.404000, "" },
	{ "CA", "CD", 469.000000, 1.400000, "" },
	{ "CA", "CJ", 427.000000, 1.433000, "" },
	{ "CA", "CM", 427.000000, 1.433000, "" },
	{ "CA", "CN", 469.000000, 1.400000, "" },
	{ "CA", "CT", 317.000000, 1.510000, "" },
	{ "CA", "HC", 340.000000, 1.080000, "" },
	{ "CA", "N2", 481.000000, 1.340000, "" },
	{ "CA", "NA", 427.000000, 1.381000, "" },
	{ "CA", "NC", 483.000000, 1.339000, "" },
	{ "CB", "CB", 520.000000, 1.370000, "" },
	{ "CB", "CD", 469.000000, 1.400000, "" },
	{ "CB", "CN", 447.000000, 1.419000, "" },
	{ "CB", "N*", 436.000000, 1.374000, "" },
	{ "CB", "NB", 414.000000, 1.391000, "" },
	{ "CB", "NC", 461.000000, 1.354000, "" },
	{ "CC", "CF", 512.000000, 1.375000, "" },
	{ "CC", "CG", 518.000000, 1.371000, "" },
	{ "CC", "CT", 317.000000, 1.504000, "" },
	{ "CC", "CV", 512.000000, 1.375000, "" },
	{ "CC", "CW", 518.000000, 1.371000, "" },
	{ "CC", "NA", 422.000000, 1.385000, "" },
	{ "CC", "NB", 410.000000, 1.394000, "" },
	{ "CD", "CD", 469.000000, 1.400000, "" },
	{ "CD", "CN", 469.000000, 1.400000, "" },
	{ "CE", "N*", 440.000000, 1.371000, "" },
	{ "CE", "NB", 529.000000, 1.304000, "" },
	{ "CF", "NB", 410.000000, 1.394000, "" },
	{ "CG", "NA", 427.000000, 1.381000, "" },
	{ "CH", "CH", 260.000000, 1.526000, "" },
	{ "CH", "N", 337.000000, 1.449000, "" },
	{ "CH", "N*", 337.000000, 1.475000, "" },
	{ "CH", "NT", 367.000000, 1.471000, "" },
	{ "CH", "OH", 386.000000, 1.425000, "" },
	{ "CH", "OS", 320.000000, 1.425000, "" },
	{ "CI", "NC", 502.000000, 1.324000, "" },
	{ "CJ", "CJ", 549.000000, 1.350000, "" },
	{ "CJ", "CM", 549.000000, 1.350000, "" },
	{ "CJ", "N*", 448.000000, 1.365000, "" },
	{ "CK", "HC", 340.000000, 1.080000, "" },
	{ "CK", "N*", 440.000000, 1.371000, "" },
	{ "CK", "NB", 529.000000, 1.304000, "" },
	{ "CM", "CM", 549.000000, 1.350000, "" },
	{ "CM", "CT", 317.000000, 1.510000, "" },
	{ "CM", "HC", 340.000000, 1.080000, "" },
	{ "CM", "N*", 448.000000, 1.365000, "" },
	{ "CN", "NA", 428.000000, 1.380000, "" },
	{ "CP", "NA", 477.000000, 1.343000, "" },
	{ "CP", "NB", 488.000000, 1.335000, "" },
	{ "CQ", "HC", 340.000000, 1.080000, "" },
	{ "CQ", "NC", 502.000000, 1.324000, "" },
	{ "CR", "HC", 340.000000, 1.080000, "" },
	{ "CR", "NA", 477.000000, 1.343000, "" },
	{ "CR", "NB", 488.000000, 1.335000, "" },
	{ "CT", "CT", 310.000000, 1.526000, "" },
	{ "CT", "HC", 331.000000, 1.090000, "" },
	{ "CT", "N", 337.000000, 1.449000, "" },
	{ "CT", "N*", 337.000000, 1.475000, "" },
	{ "CT", "N2", 337.000000, 1.463000, "" },
	{ "CT", "N3", 367.000000, 1.471000, "" },
	{ "CT", "OH", 320.000000, 1.410000, "" },
	{ "CT", "OS", 320.000000, 1.410000, "" },
	{ "CT", "S", 222.000000, 1.810000, "" },
	{ "CT", "SH", 222.000000, 1.810000, "" },
	{ "CV", "HC", 340.000000, 1.080000, "" },
	{ "CV", "NB", 410.000000, 1.394000, "" },
	{ "CW", "HC", 340.000000, 1.080000, "" },
	{ "CW", "NA", 427.000000, 1.381000, "" },
	{ "H", "N", 434.000000, 1.010000, "" },
	{ "H", "N2", 434.000000, 1.010000, "" },
	{ "H", "NA", 434.000000, 1.010000, "" },
	{ "H2", "N", 434.000000, 1.010000, "" },
	{ "H2", "N2", 434.000000, 1.010000, "" },
	{ "H2", "NT", 434.000000, 1.010000, "" },
	{ "H3", "N2", 434.000000, 1.010000, "" },
	{ "H3", "N3", 434.000000, 1.010000, "" },
	{ "HO", "OH", 553.000000, 0.960000, "" },
	{ "HO", "OS", 553.000000, 0.960000, "" },
	{ "HS", "SH", 274.000000, 1.336000, "" },
	{ "LP", "S", 600.000000, 0.679000, "" },
	{ "LP", "SH", 600.000000, 0.679000, "" },
	{ "O2", "P", 525.000000, 1.480000, "" },
	{ "OH", "P", 230.000000, 1.610000, "" },
	{ "OS", "P", 230.000000, 1.610000, "" },
	{ "S", "S", 166.000000, 2.038000, "" },
#else
	/* xplor */
	{ "C2", "NC", 400.0, 1.33 },
	{ "CF", "CB", 386.0, 1.343 },
	{ "CS", "CS", 550.0, 1.37 },
	{ "P", "OM", 900.0, 1.48 },
	{ "P", "OS", 600.0, 1.61 },
	{ "CS2", "OS", 600.0, 1.435 },
	{ "CS2", "CS1", 600.0, 1.52 },
	{ "CS1", "OS", 600.0, 1.435 },
	{ "CS1", "CS1", 600.0, 1.52 },
	{ "CS1", "NR5'", 600.0, 1.48 },
	{ "CB", "NR5'", 1000.0, 1.33 },
	{ "CR51", "NR5'", 1000.0, 1.33 },
	{ "NR6", "CB", 1000.0, 1.34 },
	{ "CB", "CB", 1000.0, 1.39 },
	{ "NR6", "CR61", 1000.0, 1.32 },
	{ "CB", "NT", 900.0, 1.33 },
	{ "HPR", "NT", 895.0, 1.00 },
	{ "CB", "NR5", 1000.0, 1.33 },
	{ "CR51", "NR5", 1000.0, 1.33 },
	{ "CS1", "OA", 600.0, 1.43 },
	{ "HO", "OA", 750.0, 1.00 },
	{ "NR6'", "CS1", 800.0, 1.48 },
	{ "NR6'", "CR61", 800.0, 1.40 },
	{ "CR61", "CR61", 1000.0, 1.39 },
	{ "CB", "CR61", 1000.0, 1.39 },
	{ "CS2", "CB", 800.0, 1.39 },
	{ "CB", "CPR", 800.0, 1.53 },
	{ "CS2", "CR61", 800.0, 1.39 },
	{ "CPR", "OPR", 1200.0, 1.23 },
	{ "CPR", "NT", 900.0, 1.33 },
	{ "CC", "OE", 296.7, 1.427 },
	{ "CC", "CC", 214.8, 1.523 },
	{ "CC", "HA", 337.3, 1.099 },
	{ "CC", "OH1", 334.3, 1.411 },
	{ "CC", "NH1", 422.0, 1.45 },
	{ "CC", "C", 405.0, 1.52 },
	{ "HN", "NA", 472.0000, 1.0100 },
	{ "HN", "NS", 472.0000, 1.0100 },
	{ "H2", "N2", 472.0000, 1.0100 },
	{ "HO", "OH", 450.0000, 0.9600 },
	{ "HO", "OS", 450.0000, 0.9600 },
	{ "P", "O2", 528.0000, 1.4800 },
	{ "P", "OS", 237.0000, 1.6100 },
	{ "P", "OH", 237.0000, 1.6100 },
	{ "OS", "C2", 292.0000, 1.4300 },
	{ "OS", "CH", 292.0000, 1.4300 },
	{ "ON", "CN", 612.0000, 1.2290 },
	{ "OH", "C2", 292.0000, 1.4300 },
	{ "OH", "CH", 292.0000, 1.4300 },
	{ "C2", "CH", 201.0000, 1.5250 },
	{ "C2", "C2", 201.0000, 1.5250 },
	{ "CH", "CH", 201.0000, 1.5250 },
	{ "C3", "CH", 201.0000, 1.5250 },
	{ "C3", "C2", 201.0000, 1.5250 },
	{ "CB", "CB", 550.0000, 1.3700 },
	{ "CA", "CB", 386.0000, 1.4040 },
	{ "CN", "CB", 386.0000, 1.4190 },
	{ "CF", "CN", 386.0000, 1.4440 },
	{ "CF", "CA", 386.0000, 1.4330 },
	{ "CF", "CF", 684.0000, 1.3500 },
	{ "CN", "CS", 386.0000, 1.4440 },
	{ "CS", "C3", 201.0000, 1.5250 },
	{ "CS", "CF", 386.0000, 1.3430 },
	{ "NS", "CH", 300.0000, 1.4750 },
	{ "NS", "CB", 337.0000, 1.3740 },
	{ "NS", "CE", 300.0000, 1.3710 },
	{ "NS", "CN", 337.0000, 1.3830 },
	{ "NS", "CF", 337.0000, 1.3650 },
	{ "NC", "CB", 400.0000, 1.3540 },
	{ "NC", "CE", 400.0000, 1.3240 },
	{ "NC", "CA", 400.0000, 1.3390 },
	{ "NC", "CN", 400.0000, 1.3580 },
	{ "N2", "CA", 400.0000, 1.3330 },
	{ "NB", "CB", 400.0000, 1.3910 },
	{ "NB", "CE", 400.0000, 1.3040 },
	{ "NA", "CA", 400.0000, 1.3810 },
	{ "NA", "CN", 337.0000, 1.3880 },
	{ "NH2E", "CH", 422.0000, 1.49 },
	{ "BR", "CS", 300.0000, 1.880 },
	{ "OS", "CH2E", 292.0000, 1.4300 },
	{ "OS", "CH1E", 292.0000, 1.4300 },
	{ "C", "C", 450.0, 1.38 },
	{ "C", "CH1E", 405.0, 1.52 },
	{ "C", "CH2E", 405.0, 1.52 },
	{ "C", "CH3E", 405.0, 1.52 },
	{ "C", "CR1E", 450.0, 1.38 },
	{ "C", "N", 471.0, 1.33 },
	{ "C", "NC2", 400.0, 1.33 },
	{ "C", "NH1", 471.0, 1.33 },
	{ "C", "NH2", 471.0, 1.33 },
	{ "C", "NP", 471.0, 1.33 },
	{ "C", "NR", 471.0, 1.33 },
	{ "C", "O", 580.0, 1.23 },
	{ "C", "OC", 580.0, 1.23 },
	{ "C", "OH1", 450.0, 1.38 },
	{ "CH1E", "CH1E", 225.0, 1.53 },
	{ "CH1E", "CH2E", 225.0, 1.52 },
	{ "CH1E", "CH3E", 225.0, 1.52 },
	{ "CH1E", "N", 422.0, 1.45 },
	{ "CH1E", "NH1", 422.0, 1.45 },
	{ "CH1E", "NH2", 422.0, 1.45 },
	{ "CH1E", "NH3", 422.0, 1.45 },
	{ "CH1E", "OH1", 400.0, 1.42 },
	{ "CH2E", "CH2E", 225.0, 1.52 },
	{ "CH2E", "CH3E", 225.0, 1.54 },
	{ "CH2E", "N", 422.0, 1.45 },
	{ "CH2E", "NH1", 422.0, 1.45 },
	{ "CH2E", "NH2", 422.0, 1.45 },
	{ "CH2E", "NH3", 422.0, 1.45 },
	{ "CH2E", "OH1", 400.0, 1.42 },
	{ "CH2E", "S", 450.0, 1.81 },
	{ "CH2E", "SH1E", 450.0, 1.81 },
	{ "CH3E", "NH1", 422.0, 1.49 },
	{ "CH3E", "S", 450.0, 1.77 },
	{ "CR1E", "CR1E", 450.0, 1.38 },
	{ "CR1E", "NH1", 450.0, 1.305 },
	{ "CR1E", "NR", 450.0, 1.305 },
	{ "H", "NH1", 405.0, 0.98 },
	{ "H", "NH2", 405.0, 0.98 },
	{ "H", "OH1", 450.0, 0.96 },
	{ "HC", "NC2", 405.0, 1.00 },
	{ "HC", "NH1", 405.0, 0.98 },
	{ "HC", "NH3", 405.0, 1.04 },
	{ "OC", "S", 400.0, 1.43 },
	{ "S", "S", 500.0, 2.02 },
	{ "C3", "NB", 400.0000, 1.49 },
	{ "C3", "N2", 400.0000, 1.45 },
	{ "C3", "OS", 292.0000, 1.38 },
	{ "C3", "NA", 400.0000, 1.49 },
	{ "C3", "CA", 386.0000, 1.525 },
	{ "C3", "NS", 400.0000, 1.49 },
	{ "CA", "C2", 386.0000, 1.525 },
	{ "CA", "NB", 450.0000, 1.391 },
	{ "CA", "CA", 400.0000, 1.37 },
	{ "CA", "CS", 400.0000, 1.44 },
	{ "CA", "NS", 400.0000, 1.37 },
	{ "C2", "CN", 337.0000, 1.44 },
	{ "C2", "NS", 337.0000, 1.48 },
	{ "CN", "CH", 405.0000, 1.52 },
	{ "CN", "OS", 292.0000, 1.43 },
	{ "CB", "NA", 325.0000, 1.388 },
	{ "CE", "NA", 300.0000, 1.381 },
	{ "C2", "NA", 300.0000, 1.381 },
	{ "CE", "N2", 400.0000, 1.333 },
	{ "CE", "CB", 400.0000, 1.404 },
	{ "CF", "NA", 301.0000, 1.365 },
	{ "CH", "N2", 422.0000, 1.475 },
	{ "CH", "NA", 422.0000, 1.45 },
	{ "CH", "CS", 400.0000, 1.525 },
	{ "CH", "CB", 400.0000, 1.525 },
	{ "HT", "OT", 450.0, 0.9572 },
	{ "HT", "HT", 0.0, 1.5139 },
	{ "HN", "NA", 472.0000, 1.0100 },
	{ "HN", "NS", 472.0000, 1.0100 },
	{ "H2", "N2", 472.0000, 1.0100 },
	{ "HO", "OH", 450.0000, 0.9600 },
	{ "HO", "OS", 450.0000, 0.9600 },
	{ "P", "O2", 528.0000, 1.4800 },
	{ "P", "OS", 237.0000, 1.6100 },
	{ "P", "OH", 237.0000, 1.6100 },
	{ "OS", "C2", 292.0000, 1.4300 },
	{ "OS", "CH", 292.0000, 1.4300 },
	{ "ON", "CN", 612.0000, 1.2290 },
	{ "OH", "C2", 292.0000, 1.4300 },
	{ "OH", "CH", 292.0000, 1.4300 },
	{ "C2", "CH", 201.0000, 1.5250 },
	{ "C2", "C2", 201.0000, 1.5250 },
	{ "CH", "CH", 201.0000, 1.5250 },
	{ "C3", "CH", 201.0000, 1.5250 },
	{ "C3", "C2", 201.0000, 1.5250 },
	{ "CB", "CB", 550.0000, 1.3700 },
	{ "CA", "CB", 386.0000, 1.4040 },
	{ "CN", "CB", 386.0000, 1.4190 },
	{ "CF", "CN", 386.0000, 1.4440 },
	{ "CF", "CA", 386.0000, 1.4330 },
	{ "CF", "CF", 684.0000, 1.3500 },
	{ "CN", "CS", 386.0000, 1.4440 },
	{ "CS", "C3", 201.0000, 1.5250 },
	{ "CS", "CF", 386.0000, 1.3430 },
	{ "NS", "CH", 300.0000, 1.4750 },
	{ "NS", "CB", 337.0000, 1.3740 },
	{ "NS", "CE", 300.0000, 1.3710 },
	{ "NS", "CN", 337.0000, 1.3830 },
	{ "NS", "CF", 337.0000, 1.3650 },
	{ "NC", "CB", 400.0000, 1.3540 },
	{ "NC", "CE", 400.0000, 1.3240 },
	{ "NC", "CA", 400.0000, 1.3390 },
	{ "NC", "CN", 400.0000, 1.3580 },
	{ "N2", "CA", 400.0000, 1.3330 },
	{ "NB", "CB", 400.0000, 1.3910 },
	{ "NB", "CE", 400.0000, 1.3040 },
	{ "NA", "CA", 400.0000, 1.3810 },
	{ "NA", "CN", 337.0000, 1.3880 },
	{ "NH2E", "CH", 422.0000, 1.49 },
	{ "BR", "CS", 300.0000, 1.880 },
	{ "C", "C", 450.0, 1.38 },
	{ "C", "CH1E", 405.0, 1.52 },
	{ "C", "CH2E", 405.0, 1.52 },
	{ "C", "CH3E", 405.0, 1.52 },
	{ "C", "CR1E", 450.0, 1.38 },
	{ "C", "CT", 305.0, 1.53 },
	{ "C", "N", 471.0, 1.33 },
	{ "C", "NC2", 400.0, 1.33 },
	{ "C", "NH1", 471.0, 1.33 },
	{ "C", "NH2", 471.0, 1.33 },
	{ "C", "NP", 471.0, 1.33 },
	{ "C", "NR", 471.0, 1.33 },
	{ "C", "O", 580.0, 1.23 },
	{ "C", "OC", 580.0, 1.23 },
	{ "C", "OH1", 450.0, 1.38 },
	{ "C", "OS", 292.0, 1.43 },
	{ "CH1E", "CH1E", 225.0, 1.53 },
	{ "CH1E", "CH2E", 225.0, 1.52 },
	{ "CH1E", "CH3E", 225.0, 1.52 },
	{ "CH1E", "N", 422.0, 1.45 },
	{ "CH1E", "NH1", 422.0, 1.45 },
	{ "CH1E", "NH2", 422.0, 1.45 },
	{ "CH1E", "NH3", 422.0, 1.45 },
	{ "CH1E", "OH1", 400.0, 1.42 },
	{ "CH2E", "CH2E", 225.0, 1.52 },
	{ "CH2E", "CH3E", 225.0, 1.54 },
	{ "CH2E", "N", 422.0, 1.45 },
	{ "CH2E", "NH1", 422.0, 1.45 },
	{ "CH2E", "NH2", 422.0, 1.45 },
	{ "CH2E", "NH3", 422.0, 1.45 },
	{ "CH2E", "OH1", 400.0, 1.42 },
	{ "CH2E", "S", 450.0, 1.81 },
	{ "CH2E", "SH1E", 450.0, 1.81 },
	{ "CH3E", "NH1", 422.0, 1.49 },
	{ "CH3E", "NR", 422.0, 1.49 },
	{ "CH3E", "S", 450.0, 1.77 },
	{ "CH3E", "OS", 292.0, 1.38 },
	{ "CM", "OM", 1115.0, 1.128 },
	{ "CR1E", "CR1E", 450.0, 1.38 },
	{ "CR1E", "NH1", 450.0, 1.305 },
	{ "CR1E", "NR", 450.0, 1.305 },
	{ "CT", "CT", 110.0, 1.53 },
	{ "CT", "CH1E", 219.0, 1.53 },
	{ "CT", "CH2E", 228.0, 1.53 },
	{ "CT", "CH3E", 238.0, 1.53 },
	{ "CT", "N", 422.0, 1.45 },
	{ "CT", "NC2", 422.0, 1.45 },
	{ "CT", "NH1", 361.0, 1.45 },
	{ "CT", "NH2", 422.0, 1.45 },
	{ "CT", "NH3", 422.0, 1.45 },
	{ "CT", "OH1", 400.0, 1.42 },
	{ "CT", "S", 450.0, 1.81 },
	{ "FE", "NP", 500.0, 2.09 },
	{ "FE", "NR", 65.0, 1.98 },
	{ "FE", "OM", 250.0, 1.8 },
	{ "H", "NH1", 405.0, 0.98 },
	{ "H", "NH2", 405.0, 0.98 },
	{ "H", "OH1", 450.0, 0.96 },
	{ "HA", "C", 350.0, 1.08 },
	{ "HA", "CT", 300.0, 1.08 },
	{ "HC", "NC2", 405.0, 1.00 },
	{ "HC", "NH1", 405.0, 0.98 },
	{ "HC", "NH3", 405.0, 1.04 },
	{ "OC", "S", 400.0, 1.43 },
	{ "OM", "OM", 600.0, 1.23 },
	{ "S", "S", 500.0, 2.02 },
	{ "FE", "OM", 250.0, 1.8 },
	{ "FE", "NR", 65.0, 1.98 },
	{ "FE", "CM", 258.0, 1.90 },
	{ "FE", "NP", 65.0, 1.96 },
	{ "CPA", "CPB", 450.0, 1.44 },
	{ "CPB", "CPB", 450.0, 1.36 },
	{ "CPA", "NP", 471.0, 1.38 },
	{ "CPB", "CH2E", 405.0, 1.52 },
	{ "CPB", "CH3E", 405.0, 1.52 },
	{ "CPB", "CR1E", 450.0, 1.38 },
	{ "CPA", "CPM", 450.0, 1.37 },
	{ "CC", "CF", 450.0, 1.40 },
	{ "CC", "CH2E", 405.0, 1.52 },
	{ "CF", "NB", 450.0, 1.40 },
	{ "NB", "CP", 450.0, 1.30 },
	{ "CP", "NA", 450.0, 1.35 },
	{ "NB", "FE", 65.0, 2.20 },
	{ "CC", "NA", 471.0, 1.40 },
	{ "NA", "H", 405.0, 0.98 },
	{ "CH2E", "CPM", 225.0, 1.54 },
	{ "CH2E", "OS", 292.0, 1.38 },
	{ "CPA", "C", 450.0, 1.36 },
	{ "CPA", "CH1E", 405.0, 1.52 },
	{ "CPA", "CH2E", 405.0, 1.53 },
	{ "CPA", "CH3E", 405.0, 1.54 },
	{ "CPB", "C", 450.0, 1.36 },
	{ "CPB", "CH1E", 405.0, 1.52 },
	{ "CR1E", "CH3E", 225.0, 1.53 },
	{ "MG", "NP", 65.0, 1.92 },
	{ "NH1", "CPA", 471.0, 1.38 },
	{ "NR", "MG", 65.0, 2.23 },
	{ "S", "CH1E", 450.0, 1.79 },
	{ "S", "FE", 450.0, 2.12 },
	{ "C", "C", 450.0, 1.38 },
	{ "C", "CH1E", 405.0, 1.52 },
	{ "C", "CH2E", 405.0, 1.52 },
	{ "C", "CH3E", 405.0, 1.52 },
	{ "C", "CR1E", 450.0, 1.38 },
	{ "C", "CT", 405.0, 1.53 },
	{ "C", "N", 471.0, 1.33 },
	{ "C", "NC2", 400.0, 1.33 },
	{ "C", "NH1", 471.0, 1.33 },
	{ "C", "NH2", 471.0, 1.33 },
	{ "C", "NP", 471.0, 1.33 },
	{ "C", "NR", 471.0, 1.33 },
	{ "C", "O", 580.0, 1.23 },
	{ "C", "OC", 580.0, 1.23 },
	{ "C", "OH1", 450.0, 1.38 },
	{ "C", "OS", 292.0, 1.43 },
	{ "CH1E", "CH1E", 225.0, 1.53 },
	{ "CH1E", "CH2E", 225.0, 1.52 },
	{ "CH1E", "CH3E", 225.0, 1.52 },
	{ "CH1E", "N", 422.0, 1.45 },
	{ "CH1E", "NH1", 422.0, 1.45 },
	{ "CH1E", "NH2", 422.0, 1.45 },
	{ "CH1E", "NH3", 422.0, 1.45 },
	{ "CH1E", "OH1", 400.0, 1.42 },
	{ "CH2E", "CH2E", 225.0, 1.52 },
	{ "CH2E", "CH3E", 225.0, 1.54 },
	{ "CH2E", "N", 422.0, 1.45 },
	{ "CH2E", "NH1", 422.0, 1.45 },
	{ "CH2E", "NH2", 422.0, 1.45 },
	{ "CH2E", "NH3", 422.0, 1.45 },
	{ "CH2E", "OH1", 400.0, 1.42 },
	{ "CH2E", "S", 450.0, 1.81 },
	{ "CH2E", "SH1E", 450.0, 1.81 },
	{ "CH3E", "NH1", 422.0, 1.49 },
	{ "CH3E", "NR", 422.0, 1.49 },
	{ "CH3E", "S", 450.0, 1.77 },
	{ "CH3E", "OS", 292.0, 1.38 },
	{ "CM", "OM", 1115.0, 1.128 },
	{ "CR1E", "CR1E", 450.0, 1.38 },
	{ "CR1E", "NH1", 450.0, 1.305 },
	{ "CR1E", "NR", 450.0, 1.305 },
	{ "CT", "CT", 200.0, 1.53 },
	{ "CT", "N", 422.0, 1.45 },
	{ "CT", "NC2", 422.0, 1.45 },
	{ "CT", "NH1", 422.0, 1.45 },
	{ "CT", "NH2", 422.0, 1.45 },
	{ "CT", "NH3", 422.0, 1.45 },
	{ "CT", "OH1", 400.0, 1.42 },
	{ "CT", "S", 450.0, 1.81 },
	{ "H", "NH1", 405.0, 0.98 },
	{ "H", "NH2", 405.0, 0.98 },
	{ "H", "OH1", 450.0, 0.96 },
	{ "HA", "C", 350.0, 1.08 },
	{ "HA", "CT", 300.0, 1.08 },
	{ "HC", "NC2", 405.0, 1.00 },
	{ "HC", "NH1", 405.0, 0.98 },
	{ "HC", "NH3", 405.0, 1.04 },
	{ "OC", "S", 400.0, 1.43 },
	{ "OM", "OM", 600.0, 1.23 },
	{ "S", "S", 500.0, 2.02 },
	{ "FE", "OM", 250.0, 1.8 },
	{ "FE", "NR", 65.0, 1.98 },
	{ "FE", "CM", 258.0, 1.90 },
	{ "FE", "NP", 65.0, 1.96 },
	{ "H", "H", 0.0, 1.6329931 },
	{ "CPA", "CPB", 450.0, 1.44 },
	{ "CPB", "CPB", 450.0, 1.36 },
	{ "CPA", "NP", 471.0, 1.38 },
	{ "CPB", "CH2E", 405.0, 1.52 },
	{ "CPB", "CH3E", 405.0, 1.52 },
	{ "CPB", "CR1E", 450.0, 1.38 },
	{ "CPA", "CPM", 450.0, 1.37 },
	{ "CC", "CF", 450.0, 1.40 },
	{ "CC", "CH2E", 405.0, 1.52 },
	{ "CF", "NB", 450.0, 1.40 },
	{ "NB", "CP", 450.0, 1.30 },
	{ "CP", "NA", 450.0, 1.35 },
	{ "NB", "FE", 65.0, 2.20 },
	{ "CC", "NA", 471.0, 1.40 },
	{ "NA", "H", 405.0, 0.98 },
	{ "CH2E", "CPM", 225.0, 1.54 },
	{ "CH2E", "OS", 292.0, 1.38 },
	{ "CPA", "C", 450.0, 1.36 },
	{ "CPA", "CH1E", 405.0, 1.52 },
	{ "CPA", "CH2E", 405.0, 1.53 },
	{ "CPA", "CH3E", 405.0, 1.54 },
	{ "CPB", "C", 450.0, 1.36 },
	{ "CPB", "CH1E", 405.0, 1.52 },
	{ "CR1E", "CH3E", 225.0, 1.53 },
	{ "MG", "NP", 65.0, 2.00 },
	{ "NH1", "CPA", 471.0, 1.38 },
	{ "NR", "MG", 65.0, 2.23 },
	{ "S", "CH1E", 450.0, 1.79 },
	{ "S", "FE", 450.0, 2.12 },
	{ "OC", "FE", 250.0, 2.09 },
	{ "CH3E", "N", 422.0, 1.45 },
	{ "ON", "N", 400.0, 1.22 },
	{ "CPM", "CPM", 225.0, 1.53 },
	{ "CPA", "O", 292.0, 1.23 },
	{ "CPB", "OS", 292.0, 1.34 },
	{ "CR1E", "O", 292.0, 1.23 },
	{ "HT", "OT", 450.0, 0.9572 },
	{ "HT", "HT", 0.0, 1.5139 },
	{ "FE", "NP", 270.2, 1.958 },
	{ "FE", "NR", 270.2, 1.98 },
	{ "CPA", "CPB", 299.8, 1.443 },
	{ "CPB", "CPB", 340.7, 1.346 },
	{ "CPA", "NP", 377.2, 1.376 },
	{ "CPA", "CPM", 360.0, 1.371 },
	{ "CPM", "HA", 367.6, 1.09 },
	{ "CPB", "CH2E", 441.3, 1.52 },
	{ "CPB", "CH3E", 441.3, 1.52 },
	{ "CPB", "CR1E", 441.3, 1.38 },
	{ "FE", "CM", 258.0, 1.90 },
	{ "FE", "OM", 250.0, 1.8 },
	{ "CC", "CH2E", 405.0, 1.52 },
	{ "CC", "CF", 450.0, 1.40 },
	{ "CF", "NB", 450.0, 1.40 },
	{ "NB", "CP", 450.0, 1.30 },
	{ "CP", "NA", 450.0, 1.35 },
	{ "NB", "FE", 65.0, 2.20 },
	{ "CC", "NA", 471.0, 1.40 },
	{ "NA", "H", 405.0, 0.98 },
	{ "FE", "O", 400.0, 2.1 },
	{ "FE", "OC", 400.0, 2.1 },
	{ "FE", "N", 400.0, 2.1 },
	{ "N", "N", 400.0, 1.4 },
	{ "C", "C", 450.0, 1.38 },
	{ "C", "CH1E", 405.0, 1.52 },
	{ "C", "CH2E", 405.0, 1.52 },
	{ "C", "CH3E", 405.0, 1.52 },
	{ "C", "CR1E", 450.0, 1.38 },
	{ "C", "N", 471.0, 1.33 },
	{ "C", "NC2", 400.0, 1.33 },
	{ "C", "NH1", 471.0, 1.33 },
	{ "C", "NH2", 471.0, 1.33 },
	{ "C", "NP", 471.0, 1.33 },
	{ "C", "NR", 471.0, 1.33 },
	{ "C", "O", 580.0, 1.23 },
	{ "C", "OC", 580.0, 1.23 },
	{ "C", "OH1", 450.0, 1.38 },
	{ "C", "OS", 292.0, 1.43 },
	{ "CH1E", "CH1E", 225.0, 1.53 },
	{ "CH1E", "CH2E", 225.0, 1.52 },
	{ "CH1E", "CH3E", 225.0, 1.52 },
	{ "CH1E", "N", 422.0, 1.45 },
	{ "CH1E", "NH1", 422.0, 1.45 },
	{ "CH1E", "NH2", 422.0, 1.45 },
	{ "CH1E", "NH3", 422.0, 1.45 },
	{ "CH1E", "OH1", 400.0, 1.42 },
	{ "CH2E", "CH2E", 225.0, 1.52 },
	{ "CH2E", "CH3E", 225.0, 1.54 },
	{ "CH2E", "N", 422.0, 1.45 },
	{ "CH2E", "NH1", 422.0, 1.45 },
	{ "CH2E", "NH2", 422.0, 1.45 },
	{ "CH2E", "NH3", 422.0, 1.45 },
	{ "CH2E", "OH1", 400.0, 1.42 },
	{ "CH2E", "S", 450.0, 1.81 },
	{ "CH2E", "SH1E", 450.0, 1.81 },
	{ "CH3E", "NH1", 422.0, 1.49 },
	{ "CH3E", "NR", 422.0, 1.49 },
	{ "CH3E", "S", 450.0, 1.77 },
	{ "CH3E", "OS", 292.0, 1.38 },
	{ "CM", "OM", 1115.0, 1.128 },
	{ "CR1E", "CR1E", 450.0, 1.38 },
	{ "CR1E", "NH1", 450.0, 1.305 },
	{ "CR1E", "NR", 450.0, 1.305 },
	{ "H", "NH1", 405.0, 0.98 },
	{ "H", "NH2", 405.0, 0.98 },
	{ "H", "OH1", 450.0, 0.96 },
	{ "HA", "C", 350.0, 1.08 },
	{ "HC", "NC2", 405.0, 1.00 },
	{ "HC", "NH1", 405.0, 0.98 },
	{ "HC", "NH3", 405.0, 1.04 },
	{ "OC", "S", 400.0, 1.43 },
	{ "OM", "OM", 600.0, 1.23 },
	{ "S", "S", 500.0, 2.02 },
	{ "C", "C", 450.0, 1.38 },
	{ "C", "CH1E", 405.0, 1.52 },
	{ "C", "CH2E", 405.0, 1.52 },
	{ "C", "CH3E", 405.0, 1.52 },
	{ "C", "CR1E", 450.0, 1.38 },
	{ "C", "N", 471.0, 1.33 },
	{ "C", "NC2", 400.0, 1.33 },
	{ "C", "NH1", 471.0, 1.33 },
	{ "C", "NH2", 471.0, 1.33 },
	{ "C", "NP", 471.0, 1.33 },
	{ "C", "NR", 471.0, 1.33 },
	{ "C", "O", 580.0, 1.23 },
	{ "C", "OC", 580.0, 1.23 },
	{ "C", "OH1", 450.0, 1.38 },
	{ "CH1E", "CH1E", 225.0, 1.53 },
	{ "CH1E", "CH2E", 225.0, 1.52 },
	{ "CH1E", "CH3E", 225.0, 1.52 },
	{ "CH1E", "N", 422.0, 1.45 },
	{ "CH1E", "NH1", 422.0, 1.45 },
	{ "CH1E", "NH2", 422.0, 1.45 },
	{ "CH1E", "NH3", 422.0, 1.45 },
	{ "CH1E", "OH1", 400.0, 1.42 },
	{ "CH2E", "CH2E", 225.0, 1.52 },
	{ "CH2E", "CH3E", 225.0, 1.54 },
	{ "CH2E", "N", 422.0, 1.45 },
	{ "CH2E", "NH1", 422.0, 1.45 },
	{ "CH2E", "NH2", 422.0, 1.45 },
	{ "CH2E", "NH3", 422.0, 1.45 },
	{ "CH2E", "OH1", 400.0, 1.42 },
	{ "CH2E", "S", 450.0, 1.81 },
	{ "CH2E", "SH1E", 450.0, 1.81 },
	{ "CH3E", "NH1", 422.0, 1.49 },
	{ "CH3E", "S", 450.0, 1.77 },
	{ "CR1E", "CR1E", 450.0, 1.38 },
	{ "CR1E", "NH1", 450.0, 1.305 },
	{ "CR1E", "NR", 450.0, 1.305 },
	{ "H", "NH1", 405.0, 0.98 },
	{ "H", "NH2", 405.0, 0.98 },
	{ "H", "OH1", 450.0, 0.96 },
	{ "HT", "OT", 450.0, 0.9572 },
	{ "HT", "HT", 0.0, 1.5139 },
	{ "HC", "NC2", 405.0, 1.00 },
	{ "HC", "NH1", 405.0, 0.98 },
	{ "HC", "NH3", 405.0, 1.04 },
	{ "OC", "S", 400.0, 1.43 },
	{ "S", "S", 500.0, 2.02 },
	{ "HN", "NA", 403.0000, 1.0100 },
	{ "H2", "N2", 403.0000, 1.0100 },
	{ "HO", "OH", 331.0000, 0.9600 },
	{ "HO", "OS", 331.0000, 0.9600 },
	{ "P", "O2", 579.0000, 1.4800 },
	{ "P", "OS", 386.0000, 1.6100 },
	{ "P", "OH", 386.0000, 1.6100 },
	{ "OS", "C2", 386.0000, 1.4260 },
	{ "OS", "CH2E", 386.0000, 1.4260 },
	{ "OS", "CH", 386.0000, 1.4260 },
	{ "OS", "CH1E", 386.0000, 1.4260 },
	{ "ON", "CN", 777.0000, 1.2290 },
	{ "OH", "C2", 386.0000, 1.4260 },
	{ "OH", "CH", 386.0000, 1.4260 },
	{ "C2", "CH", 317.0000, 1.5370 },
	{ "C2", "C2", 317.0000, 1.5370 },
	{ "CH", "CH", 317.0000, 1.5370 },
	{ "C3", "CH", 317.0000, 1.5370 },
	{ "CB", "CB", 566.0000, 1.3700 },
	{ "CA", "CB", 524.0000, 1.4040 },
	{ "CN", "CB", 488.0000, 1.4190 },
	{ "CF", "CN", 426.0000, 1.4440 },
	{ "CF", "CA", 454.0000, 1.4330 },
	{ "CF", "CF", 656.0000, 1.3500 },
	{ "CN", "C*", 426.0000, 1.4440 },
	{ "C*", "C3", 367.0000, 1.5100 },
	{ "C*", "CF", 672.0000, 1.3430 },
	{ "N*", "CH", 367.0000, 1.4750 },
	{ "N*", "CB", 514.0000, 1.3740 },
	{ "N*", "CE", 645.0000, 1.3710 },
	{ "N*", "CN", 490.0000, 1.3830 },
	{ "N*", "CF", 538.0000, 1.3650 },
	{ "NC", "CB", 566.0000, 1.3540 },
	{ "NC", "CE", 645.0000, 1.3240 },
	{ "NC", "CA", 606.0000, 1.3390 },
	{ "NC", "CN", 556.0000, 1.3580 },
	{ "N2", "CA", 469.0000, 1.3330 },
	{ "NB", "CB", 469.0000, 1.3910 },
	{ "NB", "CE", 698.0000, 1.3040 },
	{ "NA", "CA", 495.0000, 1.3810 },
	{ "NA", "CN", 477.0000, 1.3880 },
#endif
	{ 0, 0, 0, 0, 0 },
};

int
main(int argc, char **argv)
{
	bondParam	*bp;
	int		count;
	float		min, max, sum;

	if (argc != 2) {
		fprintf(stderr, "usage: %s XX\nwhere X is one of CNOHS\n",
			argv[0]);
		return 1;
	}

	count = 0;
	sum = 0.0;
	for (bp = bond_params; bp->type1 != NULL; bp += 1) {
		if ((bp->type1[0] == argv[1][0] && bp->type2[0] == argv[1][1])
		|| (bp->type1[0] == argv[1][1] && bp->type2[0] == argv[1][0])) {
			count += 1;
			sum += bp->r0;
			if (count == 1) {
				min = bp->r0;
				max = bp->r0;
			} else if (bp->r0 < min)
				min = bp->r0;
			else if (bp->r0 > max)
				max = bp->r0;
		}
	}
	if (count == 0)
		printf("none found\n");
	else
		printf("%s min = %g, mid = %g, max = %g, avg = %g\n", argv[1],
			min, (min + max) / 2, max, sum / count);
	return 0;
}
