#include "TmplMolecule.h"

static void
init_CALA(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CALA", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB1", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.075059;
	p->xyz[1] = 4.623017;
	p->xyz[2] = 1.205786;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB1"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CARG(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CARG", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN22", 1, "H3"))->getCoord();
	p->xyz[0] = 4.892216;
	p->xyz[1] = 9.903045;
	p->xyz[2] = 4.004368;
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 4.274186;
	p->xyz[1] = 5.009602;
	p->xyz[2] = 1.194577;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.973781;
	p->xyz[1] = 5.548460;
	p->xyz[2] = 0.295972;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.354271;
	p->xyz[1] = 4.863178;
	p->xyz[2] = 1.185788;
	p = (new TmplAtom(m, r, "CD", 6, "CT"))->getCoord();
	p->xyz[0] = 3.881105;
	p->xyz[1] = 5.817645;
	p->xyz[2] = 2.426721;
	p = (new TmplAtom(m, r, "HD3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.181626;
	p->xyz[1] = 5.279602;
	p->xyz[2] = 3.325774;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.801135;
	p->xyz[1] = 5.964881;
	p->xyz[2] = 2.435959;
	p = (new TmplAtom(m, r, "NE", 7, "N2"))->getCoord();
	p->xyz[0] = 4.540320;
	p->xyz[1] = 7.142723;
	p->xyz[2] = 2.424483;
	p = (new TmplAtom(m, r, "HNE", 1, "H3"))->getCoord();
	p->xyz[0] = 5.151805;
	p->xyz[1] = 7.375492;
	p->xyz[2] = 1.655065;
	p = (new TmplAtom(m, r, "CZ", 6, "CA"))->getCoord();
	p->xyz[0] = 4.364284;
	p->xyz[1] = 8.040989;
	p->xyz[2] = 3.389382;
	p = (new TmplAtom(m, r, "NH1", 7, "N2"))->getCoord();
	p->xyz[0] = 3.575026;
	p->xyz[1] = 7.807606;
	p->xyz[2] = 4.434133;
	p = (new TmplAtom(m, r, "HN11", 1, "H3"))->getCoord();
	p->xyz[0] = 3.088949;
	p->xyz[1] = 6.925423;
	p->xyz[2] = 4.508848;
	p = (new TmplAtom(m, r, "HN12", 1, "H3"))->getCoord();
	p->xyz[0] = 3.465367;
	p->xyz[1] = 8.513631;
	p->xyz[2] = 5.147998;
	p = (new TmplAtom(m, r, "NH2", 7, "N2"))->getCoord();
	p->xyz[0] = 5.006254;
	p->xyz[1] = 9.201287;
	p->xyz[2] = 3.286991;
	p = (new TmplAtom(m, r, "HN21", 1, "H3"))->getCoord();
	p->xyz[0] = 5.604855;
	p->xyz[1] = 9.375325;
	p->xyz[2] = 2.492329;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD3"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("NE"));
	(void) new TmplBond(r->lookupAtom("NE"), r->lookupAtom("HNE"));
	(void) new TmplBond(r->lookupAtom("NE"), r->lookupAtom("CZ"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("NH1"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("NH2"));
	(void) new TmplBond(r->lookupAtom("NH1"), r->lookupAtom("HN11"));
	(void) new TmplBond(r->lookupAtom("NH1"), r->lookupAtom("HN12"));
	(void) new TmplBond(r->lookupAtom("NH2"), r->lookupAtom("HN21"));
	(void) new TmplBond(r->lookupAtom("NH2"), r->lookupAtom("HN22"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CASN(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CASN", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "C"))->getCoord();
	p->xyz[0] = 4.253700;
	p->xyz[1] = 5.017112;
	p->xyz[2] = 1.232144;
	p = (new TmplAtom(m, r, "OD1", 8, "O"))->getCoord();
	p->xyz[0] = 5.005299;
	p->xyz[1] = 5.340406;
	p->xyz[2] = 0.315072;
	p = (new TmplAtom(m, r, "ND2", 7, "N"))->getCoord();
	p->xyz[0] = 3.984885;
	p->xyz[1] = 5.817909;
	p->xyz[2] = 2.265917;
	p = (new TmplAtom(m, r, "HND1", 1, "H"))->getCoord();
	p->xyz[0] = 3.359611;
	p->xyz[1] = 5.504297;
	p->xyz[2] = 2.994464;
	p = (new TmplAtom(m, r, "HND2", 1, "H"))->getCoord();
	p->xyz[0] = 4.408015;
	p->xyz[1] = 6.733702;
	p->xyz[2] = 2.314743;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("OD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("ND2"));
	(void) new TmplBond(r->lookupAtom("ND2"), r->lookupAtom("HND1"));
	(void) new TmplBond(r->lookupAtom("ND2"), r->lookupAtom("HND2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CASP(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CASP", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "C"))->getCoord();
	p->xyz[0] = 4.275101;
	p->xyz[1] = 5.011380;
	p->xyz[2] = 1.194527;
	p = (new TmplAtom(m, r, "OD1", 8, "O2"))->getCoord();
	p->xyz[0] = 3.669108;
	p->xyz[1] = 5.954940;
	p->xyz[2] = 0.620011;
	p = (new TmplAtom(m, r, "OD2", 8, "O2"))->getCoord();
	p->xyz[0] = 5.407731;
	p->xyz[1] = 5.091879;
	p->xyz[2] = 1.740667;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("OD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("OD2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CCYS(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CCYS", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "SG", 16, "SH"))->getCoord();
	p->xyz[0] = 4.309573;
	p->xyz[1] = 5.303523;
	p->xyz[2] = 1.366036;
	p = (new TmplAtom(m, r, "HSG", 1, "HS"))->getCoord();
	p->xyz[0] = 3.725392;
	p->xyz[1] = 5.622018;
	p->xyz[2] = 2.517640;
	p = (new TmplAtom(m, r, "LP1", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 4.051873;
	p->xyz[1] = 5.551721;
	p->xyz[2] = 0.788949;
	p = (new TmplAtom(m, r, "LP2", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 4.957926;
	p->xyz[1] = 5.101952;
	p->xyz[2] = 1.372959;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("SG"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("HSG"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("LP1"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("LP2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CCYX(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CCYX", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "SG", 16, "S"))->getCoord();
	p->xyz[0] = 4.309573;
	p->xyz[1] = 5.303523;
	p->xyz[2] = 1.366036;
	p = (new TmplAtom(m, r, "LP1", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 4.051873;
	p->xyz[1] = 5.551721;
	p->xyz[2] = 0.788949;
	p = (new TmplAtom(m, r, "LP2", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 4.957926;
	p->xyz[1] = 5.101952;
	p->xyz[2] = 1.372959;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("SG"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("LP1"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("LP2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CGLN(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CGLN", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 4.274186;
	p->xyz[1] = 5.009602;
	p->xyz[2] = 1.194577;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.973781;
	p->xyz[1] = 5.548460;
	p->xyz[2] = 0.295972;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.354271;
	p->xyz[1] = 4.863178;
	p->xyz[2] = 1.185788;
	p = (new TmplAtom(m, r, "CD", 6, "C"))->getCoord();
	p->xyz[0] = 3.906976;
	p->xyz[1] = 5.848443;
	p->xyz[2] = 2.410302;
	p = (new TmplAtom(m, r, "OE1", 8, "O"))->getCoord();
	p->xyz[0] = 3.138962;
	p->xyz[1] = 5.408349;
	p->xyz[2] = 3.262893;
	p = (new TmplAtom(m, r, "NE2", 7, "N"))->getCoord();
	p->xyz[0] = 4.458856;
	p->xyz[1] = 7.061523;
	p->xyz[2] = 2.488333;
	p = (new TmplAtom(m, r, "HNE1", 1, "H"))->getCoord();
	p->xyz[0] = 5.084281;
	p->xyz[1] = 7.376210;
	p->xyz[2] = 1.760379;
	p = (new TmplAtom(m, r, "HNE2", 1, "H"))->getCoord();
	p->xyz[0] = 4.248434;
	p->xyz[1] = 7.659045;
	p->xyz[2] = 3.274966;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("OE1"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("NE2"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("HNE1"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("HNE2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CGLU(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CGLU", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 4.267328;
	p->xyz[1] = 4.996267;
	p->xyz[2] = 1.194946;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.966923;
	p->xyz[1] = 5.535124;
	p->xyz[2] = 0.296342;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.347413;
	p->xyz[1] = 4.849843;
	p->xyz[2] = 1.186158;
	p = (new TmplAtom(m, r, "CD", 6, "C"))->getCoord();
	p->xyz[0] = 3.873732;
	p->xyz[1] = 5.805369;
	p->xyz[2] = 2.428706;
	p = (new TmplAtom(m, r, "OE1", 8, "O2"))->getCoord();
	p->xyz[0] = 4.594590;
	p->xyz[1] = 5.679012;
	p->xyz[2] = 3.454376;
	p = (new TmplAtom(m, r, "OE2", 8, "O2"))->getCoord();
	p->xyz[0] = 2.855965;
	p->xyz[1] = 6.542070;
	p->xyz[2] = 2.333721;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("OE1"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("OE2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CGLY(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CGLY", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA2", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671668;
	p->xyz[1] = 3.400125;
	p->xyz[2] = 0.889824;
	p = (new TmplAtom(m, r, "HA3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.483710;
	p->xyz[1] = 2.686702;
	p->xyz[2] = -4.438953E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 5.993369;
	p->xyz[1] = 1.568360;
	p->xyz[2] = -8.469904E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.214748;
	p->xyz[1] = 3.674642;
	p->xyz[2] = -2.513117E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA2"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA3"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CHID(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CHID", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CC"))->getCoord();
	p->xyz[0] = 4.200813;
	p->xyz[1] = 5.026064;
	p->xyz[2] = 1.321087;
	p = (new TmplAtom(m, r, "ND1", 7, "NA"))->getCoord();
	p->xyz[0] = 3.942782;
	p->xyz[1] = 5.885086;
	p->xyz[2] = 2.382972;
	p = (new TmplAtom(m, r, "HND", 1, "H"))->getCoord();
	p->xyz[0] = 3.339725;
	p->xyz[1] = 5.691913;
	p->xyz[2] = 3.169805;
	p = (new TmplAtom(m, r, "CE1", 6, "CR"))->getCoord();
	p->xyz[0] = 4.624274;
	p->xyz[1] = 6.997642;
	p->xyz[2] = 2.182500;
	p = (new TmplAtom(m, r, "HE", 1, "HC"))->getCoord();
	p->xyz[0] = 4.563048;
	p->xyz[1] = 7.811875;
	p->xyz[2] = 2.904563;
	p = (new TmplAtom(m, r, "NE2", 7, "NB"))->getCoord();
	p->xyz[0] = 5.294011;
	p->xyz[1] = 6.891451;
	p->xyz[2] = 1.061663;
	p = (new TmplAtom(m, r, "CD2", 6, "CV"))->getCoord();
	p->xyz[0] = 5.058974;
	p->xyz[1] = 5.678868;
	p->xyz[2] = 0.492453;
	p = (new TmplAtom(m, r, "HD", 1, "HC"))->getCoord();
	p->xyz[0] = 5.537741;
	p->xyz[1] = 5.417846;
	p->xyz[2] = -0.451343;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("ND1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("HND"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("NE2"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CHIE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CHIE", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CC"))->getCoord();
	p->xyz[0] = 4.200813;
	p->xyz[1] = 5.026064;
	p->xyz[2] = 1.321087;
	p = (new TmplAtom(m, r, "ND1", 7, "NB"))->getCoord();
	p->xyz[0] = 3.942782;
	p->xyz[1] = 5.885086;
	p->xyz[2] = 2.382972;
	p = (new TmplAtom(m, r, "CE1", 6, "CR"))->getCoord();
	p->xyz[0] = 4.624274;
	p->xyz[1] = 6.997642;
	p->xyz[2] = 2.182500;
	p = (new TmplAtom(m, r, "HE", 1, "HC"))->getCoord();
	p->xyz[0] = 4.563048;
	p->xyz[1] = 7.811875;
	p->xyz[2] = 2.904563;
	p = (new TmplAtom(m, r, "NE2", 7, "NA"))->getCoord();
	p->xyz[0] = 5.294011;
	p->xyz[1] = 6.891451;
	p->xyz[2] = 1.061663;
	p = (new TmplAtom(m, r, "HNE", 1, "H"))->getCoord();
	p->xyz[0] = 5.896297;
	p->xyz[1] = 7.605085;
	p->xyz[2] = 0.676854;
	p = (new TmplAtom(m, r, "CD2", 6, "CW"))->getCoord();
	p->xyz[0] = 5.058974;
	p->xyz[1] = 5.678868;
	p->xyz[2] = 0.492453;
	p = (new TmplAtom(m, r, "HD", 1, "HC"))->getCoord();
	p->xyz[0] = 5.537741;
	p->xyz[1] = 5.417846;
	p->xyz[2] = -0.451343;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("ND1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("NE2"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("HNE"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CHIP(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CHIP", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CC"))->getCoord();
	p->xyz[0] = 4.200813;
	p->xyz[1] = 5.026064;
	p->xyz[2] = 1.321087;
	p = (new TmplAtom(m, r, "ND1", 7, "NA"))->getCoord();
	p->xyz[0] = 3.942782;
	p->xyz[1] = 5.885086;
	p->xyz[2] = 2.382972;
	p = (new TmplAtom(m, r, "HND", 1, "H"))->getCoord();
	p->xyz[0] = 3.339725;
	p->xyz[1] = 5.691913;
	p->xyz[2] = 3.169805;
	p = (new TmplAtom(m, r, "CE1", 6, "CR"))->getCoord();
	p->xyz[0] = 4.624274;
	p->xyz[1] = 6.997642;
	p->xyz[2] = 2.182500;
	p = (new TmplAtom(m, r, "HE", 1, "HC"))->getCoord();
	p->xyz[0] = 4.563048;
	p->xyz[1] = 7.811875;
	p->xyz[2] = 2.904563;
	p = (new TmplAtom(m, r, "NE2", 7, "NA"))->getCoord();
	p->xyz[0] = 5.294011;
	p->xyz[1] = 6.891451;
	p->xyz[2] = 1.061663;
	p = (new TmplAtom(m, r, "HNE", 1, "H"))->getCoord();
	p->xyz[0] = 5.896297;
	p->xyz[1] = 7.605085;
	p->xyz[2] = 0.676854;
	p = (new TmplAtom(m, r, "CD2", 6, "CW"))->getCoord();
	p->xyz[0] = 5.058974;
	p->xyz[1] = 5.678868;
	p->xyz[2] = 0.492453;
	p = (new TmplAtom(m, r, "HD", 1, "HC"))->getCoord();
	p->xyz[0] = 5.537741;
	p->xyz[1] = 5.417846;
	p->xyz[2] = -0.451343;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("ND1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("HND"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("NE2"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("HNE"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CILE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CILE", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.552136;
	p->xyz[1] = 3.620733;
	p->xyz[2] = 1.245168;
	p = (new TmplAtom(m, r, "HB", 1, "HC"))->getCoord();
	p->xyz[0] = 2.470128;
	p->xyz[1] = 3.752486;
	p->xyz[2] = 1.245640;
	p = (new TmplAtom(m, r, "CG2", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970045;
	p->xyz[1] = 2.845728;
	p->xyz[2] = 2.490296;
	p = (new TmplAtom(m, r, "HG21", 1, "HC"))->getCoord();
	p->xyz[0] = 5.052053;
	p->xyz[1] = 2.713974;
	p->xyz[2] = 2.490763;
	p = (new TmplAtom(m, r, "HG22", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671561;
	p->xyz[1] = 3.399208;
	p->xyz[2] = 3.380615;
	p = (new TmplAtom(m, r, "HG23", 1, "HC"))->getCoord();
	p->xyz[0] = 3.485650;
	p->xyz[1] = 1.869275;
	p->xyz[2] = 2.490737;
	p = (new TmplAtom(m, r, "CG1", 6, "CT"))->getCoord();
	p->xyz[0] = 4.230204;
	p->xyz[1] = 4.986694;
	p->xyz[2] = 1.245169;
	p = (new TmplAtom(m, r, "HG12", 1, "HC"))->getCoord();
	p->xyz[0] = 3.931820;
	p->xyz[1] = 5.541027;
	p->xyz[2] = 0.355348;
	p = (new TmplAtom(m, r, "HG13", 1, "HC"))->getCoord();
	p->xyz[0] = 5.312310;
	p->xyz[1] = 4.855746;
	p->xyz[2] = 1.245164;
	p = (new TmplAtom(m, r, "CD1", 6, "CT"))->getCoord();
	p->xyz[0] = 3.812294;
	p->xyz[1] = 5.761632;
	p->xyz[2] = 2.490339;
	p = (new TmplAtom(m, r, "HD1", 1, "HC"))->getCoord();
	p->xyz[0] = 4.110777;
	p->xyz[1] = 5.208104;
	p->xyz[2] = 3.380628;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.296689;
	p->xyz[1] = 6.738085;
	p->xyz[2] = 2.490833;
	p = (new TmplAtom(m, r, "HD3", 1, "HC"))->getCoord();
	p->xyz[0] = 2.730286;
	p->xyz[1] = 5.893383;
	p->xyz[2] = 2.490813;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG1"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG21"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG22"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG23"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG12"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG13"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD1"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD3"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CLEU(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CLEU", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 4.274186;
	p->xyz[1] = 5.009602;
	p->xyz[2] = 1.194577;
	p = (new TmplAtom(m, r, "HG", 1, "HC"))->getCoord();
	p->xyz[0] = 5.354271;
	p->xyz[1] = 4.863178;
	p->xyz[2] = 1.185788;
	p = (new TmplAtom(m, r, "CD1", 6, "CT"))->getCoord();
	p->xyz[0] = 3.853429;
	p->xyz[1] = 5.762895;
	p->xyz[2] = -0.062857;
	p = (new TmplAtom(m, r, "HD11", 1, "HC"))->getCoord();
	p->xyz[0] = 2.773449;
	p->xyz[1] = 5.910113;
	p->xyz[2] = -0.054557;
	p = (new TmplAtom(m, r, "HD12", 1, "HC"))->getCoord();
	p->xyz[0] = 4.351513;
	p->xyz[1] = 6.732052;
	p->xyz[2] = -0.090203;
	p = (new TmplAtom(m, r, "HD13", 1, "HC"))->getCoord();
	p->xyz[0] = 4.134159;
	p->xyz[1] = 5.185704;
	p->xyz[2] = -0.943846;
	p = (new TmplAtom(m, r, "CD2", 6, "CT"))->getCoord();
	p->xyz[0] = 3.881105;
	p->xyz[1] = 5.817645;
	p->xyz[2] = 2.426721;
	p = (new TmplAtom(m, r, "HD21", 1, "HC"))->getCoord();
	p->xyz[0] = 4.181626;
	p->xyz[1] = 5.279602;
	p->xyz[2] = 3.325774;
	p = (new TmplAtom(m, r, "HD22", 1, "HC"))->getCoord();
	p->xyz[0] = 4.379198;
	p->xyz[1] = 6.786825;
	p->xyz[2] = 2.400363;
	p = (new TmplAtom(m, r, "HD23", 1, "HC"))->getCoord();
	p->xyz[0] = 2.801135;
	p->xyz[1] = 5.964881;
	p->xyz[2] = 2.435959;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD11"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD12"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD13"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD21"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD22"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD23"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CLYS(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CLYS", MolResId(seqno));
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 4.274186;
	p->xyz[1] = 5.009602;
	p->xyz[2] = 1.194577;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.973781;
	p->xyz[1] = 5.548460;
	p->xyz[2] = 0.295972;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.354271;
	p->xyz[1] = 4.863178;
	p->xyz[2] = 1.185788;
	p = (new TmplAtom(m, r, "CD", 6, "CT"))->getCoord();
	p->xyz[0] = 3.881105;
	p->xyz[1] = 5.817645;
	p->xyz[2] = 2.426721;
	p = (new TmplAtom(m, r, "HD3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.181626;
	p->xyz[1] = 5.279602;
	p->xyz[2] = 3.325774;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.801135;
	p->xyz[1] = 5.964881;
	p->xyz[2] = 2.435959;
	p = (new TmplAtom(m, r, "CE", 6, "CT"))->getCoord();
	p->xyz[0] = 4.578325;
	p->xyz[1] = 7.173410;
	p->xyz[2] = 2.389153;
	p = (new TmplAtom(m, r, "HE3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.277917;
	p->xyz[1] = 7.712267;
	p->xyz[2] = 1.490550;
	p = (new TmplAtom(m, r, "HE2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.658410;
	p->xyz[1] = 7.026987;
	p->xyz[2] = 2.380363;
	p = (new TmplAtom(m, r, "NZ", 7, "N3"))->getCoord();
	p->xyz[0] = 4.199422;
	p->xyz[1] = 7.952309;
	p->xyz[2] = 3.576860;
	p = (new TmplAtom(m, r, "HNZ1", 1, "H3"))->getCoord();
	p->xyz[0] = 4.478085;
	p->xyz[1] = 7.453366;
	p->xyz[2] = 4.409628;
	p = (new TmplAtom(m, r, "HNZ2", 1, "H3"))->getCoord();
	p->xyz[0] = 4.661186;
	p->xyz[1] = 8.850226;
	p->xyz[2] = 3.551979;
	p = (new TmplAtom(m, r, "HNZ3", 1, "H3"))->getCoord();
	p->xyz[0] = 3.198675;
	p->xyz[1] = 8.088466;
	p->xyz[2] = 3.584971;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD3"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("CE"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE3"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE2"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("NZ"));
	(void) new TmplBond(r->lookupAtom("NZ"), r->lookupAtom("HNZ1"));
	(void) new TmplBond(r->lookupAtom("NZ"), r->lookupAtom("HNZ2"));
	(void) new TmplBond(r->lookupAtom("NZ"), r->lookupAtom("HNZ3"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CMET(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CMET", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 4.274186;
	p->xyz[1] = 5.009602;
	p->xyz[2] = 1.194577;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.973781;
	p->xyz[1] = 5.548460;
	p->xyz[2] = 0.295972;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.354271;
	p->xyz[1] = 4.863178;
	p->xyz[2] = 1.185788;
	p = (new TmplAtom(m, r, "SD", 16, "S"))->getCoord();
	p->xyz[0] = 3.817309;
	p->xyz[1] = 5.981266;
	p->xyz[2] = 2.651708;
	p = (new TmplAtom(m, r, "LP1", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 4.055311;
	p->xyz[1] = 5.545791;
	p->xyz[2] = 3.115127;
	p = (new TmplAtom(m, r, "LP2", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 3.149256;
	p->xyz[1] = 5.995559;
	p->xyz[2] = 2.531116;
	p = (new TmplAtom(m, r, "CE", 6, "CT"))->getCoord();
	p->xyz[0] = 4.753212;
	p->xyz[1] = 7.463128;
	p->xyz[2] = 2.340949;
	p = (new TmplAtom(m, r, "HE1", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433582;
	p->xyz[1] = 7.904044;
	p->xyz[2] = 1.396741;
	p = (new TmplAtom(m, r, "HE2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.585907;
	p->xyz[1] = 8.175299;
	p->xyz[2] = 3.148985;
	p = (new TmplAtom(m, r, "HE3", 1, "HC"))->getCoord();
	p->xyz[0] = 5.814074;
	p->xyz[1] = 7.218763;
	p->xyz[2] = 2.286554;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("SD"));
	(void) new TmplBond(r->lookupAtom("SD"), r->lookupAtom("LP1"));
	(void) new TmplBond(r->lookupAtom("SD"), r->lookupAtom("LP2"));
	(void) new TmplBond(r->lookupAtom("SD"), r->lookupAtom("CE"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE1"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE2"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE3"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CPHE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CPHE", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CA"))->getCoord();
	p->xyz[0] = 4.200813;
	p->xyz[1] = 5.026064;
	p->xyz[2] = 1.321087;
	p = (new TmplAtom(m, r, "CD1", 6, "CA"))->getCoord();
	p->xyz[0] = 3.911613;
	p->xyz[1] = 5.857250;
	p->xyz[2] = 2.409890;
	p = (new TmplAtom(m, r, "HD1", 1, "HC"))->getCoord();
	p->xyz[0] = 3.236123;
	p->xyz[1] = 5.513843;
	p->xyz[2] = 3.193398;
	p = (new TmplAtom(m, r, "CE1", 6, "CA"))->getCoord();
	p->xyz[0] = 4.490014;
	p->xyz[1] = 7.129513;
	p->xyz[2] = 2.492354;
	p = (new TmplAtom(m, r, "HE1", 1, "HC"))->getCoord();
	p->xyz[0] = 4.264853;
	p->xyz[1] = 7.776651;
	p->xyz[2] = 3.340066;
	p = (new TmplAtom(m, r, "CZ", 6, "CA"))->getCoord();
	p->xyz[0] = 5.357616;
	p->xyz[1] = 7.570591;
	p->xyz[2] = 1.486016;
	p = (new TmplAtom(m, r, "HZ", 1, "HC"))->getCoord();
	p->xyz[0] = 5.807943;
	p->xyz[1] = 8.561138;
	p->xyz[2] = 1.550220;
	p = (new TmplAtom(m, r, "CE2", 6, "CA"))->getCoord();
	p->xyz[0] = 5.646818;
	p->xyz[1] = 6.739407;
	p->xyz[2] = 0.397211;
	p = (new TmplAtom(m, r, "HE2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.322309;
	p->xyz[1] = 7.082817;
	p->xyz[2] = -0.386295;
	p = (new TmplAtom(m, r, "CD2", 6, "CA"))->getCoord();
	p->xyz[0] = 5.068419;
	p->xyz[1] = 5.467143;
	p->xyz[2] = 0.314744;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.293584;
	p->xyz[1] = 4.820007;
	p->xyz[2] = -0.532968;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD1"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("CZ"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("HZ"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("CE2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("HE2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CPRO(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CPRO", MolResId(seqno));
	p = (new TmplAtom(m, r, "CD", 6, "CT"))->getCoord();
	p->xyz[0] = 4.302147;
	p->xyz[1] = 0.476598;
	p->xyz[2] = 0.080119;
	p = (new TmplAtom(m, r, "HD3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.419998;
	p->xyz[1] = 0.019283;
	p->xyz[2] = -0.902263;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 3.955888;
	p->xyz[1] = -0.274040;
	p->xyz[2] = 0.790574;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 5.547126;
	p->xyz[1] = 1.172441;
	p->xyz[2] = 0.544693;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 5.652950;
	p->xyz[1] = 1.047934;
	p->xyz[2] = 1.622376;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.413549;
	p->xyz[1] = 0.741636;
	p->xyz[2] = 0.042879;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 5.369091;
	p->xyz[1] = 2.628184;
	p->xyz[2] = 0.185227;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 5.690642;
	p->xyz[1] = 3.251038;
	p->xyz[2] = 1.019947;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.969289;
	p->xyz[1] = 2.861861;
	p->xyz[2] = -0.694123;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.933610;
	p->xyz[1] = 2.871277;
	p->xyz[2] = -0.104508;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.932646;
	p->xyz[1] = 3.351378;
	p->xyz[2] = 0.874063;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 2.872957;
	p->xyz[1] = 3.958250;
	p->xyz[2] = -0.204452;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 1.678863;
	p->xyz[1] = 3.667760;
	p->xyz[2] = -0.190495;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 3.197671;
	p->xyz[1] = 5.139693;
	p->xyz[2] = -0.300332;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.326834;
	p->xyz[1] = 1.557389;
	p->xyz[2] = -1.603999E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD3"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CSER(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CSER", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "OG", 8, "OH"))->getCoord();
	p->xyz[0] = 4.230753;
	p->xyz[1] = 4.925145;
	p->xyz[2] = 1.196917;
	p = (new TmplAtom(m, r, "HOG", 1, "HO"))->getCoord();
	p->xyz[0] = 3.983305;
	p->xyz[1] = 5.433814;
	p->xyz[2] = 1.972562;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("OG"));
	(void) new TmplBond(r->lookupAtom("OG"), r->lookupAtom("HOG"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CTHR(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CTHR", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB", 1, "HC"))->getCoord();
	p->xyz[0] = 4.075059;
	p->xyz[1] = 4.623017;
	p->xyz[2] = 1.205786;
	p = (new TmplAtom(m, r, "CG2", 6, "CT"))->getCoord();
	p->xyz[0] = 2.065936;
	p->xyz[1] = 3.859425;
	p->xyz[2] = 1.244383;
	p = (new TmplAtom(m, r, "HG1", 1, "HC"))->getCoord();
	p->xyz[0] = 1.567127;
	p->xyz[1] = 2.890627;
	p->xyz[2] = 1.271209;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.784431;
	p->xyz[1] = 4.436953;
	p->xyz[2] = 2.124903;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 1.764699;
	p->xyz[1] = 4.397847;
	p->xyz[2] = 0.345796;
	p = (new TmplAtom(m, r, "OG1", 8, "OH"))->getCoord();
	p->xyz[0] = 3.971501;
	p->xyz[1] = 2.947413;
	p->xyz[2] = 2.411212;
	p = (new TmplAtom(m, r, "HOG", 1, "HO"))->getCoord();
	p->xyz[0] = 3.724052;
	p->xyz[1] = 3.456082;
	p->xyz[2] = 3.186857;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("OG1"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG1"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("OG1"), r->lookupAtom("HOG"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CTRP(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CTRP", MolResId(seqno));
	p = (new TmplAtom(m, r, "CD2", 6, "CB"))->getCoord();
	p->xyz[0] = 5.083390;
	p->xyz[1] = 5.623004;
	p->xyz[2] = 0.411545;
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "C*"))->getCoord();
	p->xyz[0] = 4.200813;
	p->xyz[1] = 5.026064;
	p->xyz[2] = 1.321087;
	p = (new TmplAtom(m, r, "CD1", 6, "CW"))->getCoord();
	p->xyz[0] = 4.023453;
	p->xyz[1] = 5.931084;
	p->xyz[2] = 2.293240;
	p = (new TmplAtom(m, r, "HD", 1, "HC"))->getCoord();
	p->xyz[0] = 3.368841;
	p->xyz[1] = 5.705466;
	p->xyz[2] = 3.135071;
	p = (new TmplAtom(m, r, "NE1", 7, "NA"))->getCoord();
	p->xyz[0] = 4.811943;
	p->xyz[1] = 7.073555;
	p->xyz[2] = 1.949808;
	p = (new TmplAtom(m, r, "HNE", 1, "H"))->getCoord();
	p->xyz[0] = 4.882921;
	p->xyz[1] = 7.922010;
	p->xyz[2] = 2.493118;
	p = (new TmplAtom(m, r, "CE2", 6, "CN"))->getCoord();
	p->xyz[0] = 5.427347;
	p->xyz[1] = 6.842060;
	p->xyz[2] = 0.816764;
	p = (new TmplAtom(m, r, "CZ2", 6, "CA"))->getCoord();
	p->xyz[0] = 6.297161;
	p->xyz[1] = 7.689052;
	p->xyz[2] = 0.119605;
	p = (new TmplAtom(m, r, "HZ1", 1, "HC"))->getCoord();
	p->xyz[0] = 6.531230;
	p->xyz[1] = 8.676649;
	p->xyz[2] = 0.517050;
	p = (new TmplAtom(m, r, "CH2", 6, "CA"))->getCoord();
	p->xyz[0] = 6.814091;
	p->xyz[1] = 7.187011;
	p->xyz[2] = -1.069023;
	p = (new TmplAtom(m, r, "HH", 1, "HC"))->getCoord();
	p->xyz[0] = 7.498074;
	p->xyz[1] = 7.791857;
	p->xyz[2] = -1.664362;
	p = (new TmplAtom(m, r, "CZ3", 6, "CA"))->getCoord();
	p->xyz[0] = 6.482659;
	p->xyz[1] = 5.953119;
	p->xyz[2] = -1.505101;
	p = (new TmplAtom(m, r, "HZ2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.897660;
	p->xyz[1] = 5.575648;
	p->xyz[2] = -2.439654;
	p = (new TmplAtom(m, r, "CE3", 6, "CA"))->getCoord();
	p->xyz[0] = 5.604041;
	p->xyz[1] = 5.117355;
	p->xyz[2] = -0.785636;
	p = (new TmplAtom(m, r, "HE", 1, "HC"))->getCoord();
	p->xyz[0] = 5.358720;
	p->xyz[1] = 4.126570;
	p->xyz[2] = -1.168080;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("NE1"));
	(void) new TmplBond(r->lookupAtom("NE1"), r->lookupAtom("HNE"));
	(void) new TmplBond(r->lookupAtom("NE1"), r->lookupAtom("CE2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("CZ2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CZ2"), r->lookupAtom("HZ1"));
	(void) new TmplBond(r->lookupAtom("CZ2"), r->lookupAtom("CH2"));
	(void) new TmplBond(r->lookupAtom("CH2"), r->lookupAtom("HH"));
	(void) new TmplBond(r->lookupAtom("CH2"), r->lookupAtom("CZ3"));
	(void) new TmplBond(r->lookupAtom("CZ3"), r->lookupAtom("HZ2"));
	(void) new TmplBond(r->lookupAtom("CZ3"), r->lookupAtom("CE3"));
	(void) new TmplBond(r->lookupAtom("CE3"), r->lookupAtom("HE"));
	(void) new TmplBond(r->lookupAtom("CE3"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CTYR(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CTYR", MolResId(seqno));
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.877484;
	p->xyz[1] = 3.115795;
	p->xyz[2] = 2.131197;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG", 6, "CA"))->getCoord();
	p->xyz[0] = 4.267328;
	p->xyz[1] = 4.996267;
	p->xyz[2] = 1.194946;
	p = (new TmplAtom(m, r, "CD1", 6, "CA"))->getCoord();
	p->xyz[0] = 4.059927;
	p->xyz[1] = 5.918911;
	p->xyz[2] = 2.227280;
	p = (new TmplAtom(m, r, "HD1", 1, "HC"))->getCoord();
	p->xyz[0] = 3.400108;
	p->xyz[1] = 5.668218;
	p->xyz[2] = 3.057877;
	p = (new TmplAtom(m, r, "CE1", 6, "CA"))->getCoord();
	p->xyz[0] = 4.699998;
	p->xyz[1] = 7.163547;
	p->xyz[2] = 2.192791;
	p = (new TmplAtom(m, r, "HE1", 1, "HC"))->getCoord();
	p->xyz[0] = 4.538522;
	p->xyz[1] = 7.881891;
	p->xyz[2] = 2.996538;
	p = (new TmplAtom(m, r, "CZ", 6, "C"))->getCoord();
	p->xyz[0] = 5.547471;
	p->xyz[1] = 7.485542;
	p->xyz[2] = 1.125970;
	p = (new TmplAtom(m, r, "OH", 8, "OH"))->getCoord();
	p->xyz[0] = 6.169255;
	p->xyz[1] = 8.694617;
	p->xyz[2] = 1.092468;
	p = (new TmplAtom(m, r, "HOH", 1, "HO"))->getCoord();
	p->xyz[0] = 5.956327;
	p->xyz[1] = 9.246984;
	p->xyz[2] = 1.848214;
	p = (new TmplAtom(m, r, "CE2", 6, "CA"))->getCoord();
	p->xyz[0] = 5.754875;
	p->xyz[1] = 6.562900;
	p->xyz[2] = 0.093635;
	p = (new TmplAtom(m, r, "HE2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.414694;
	p->xyz[1] = 6.813595;
	p->xyz[2] = -0.736962;
	p = (new TmplAtom(m, r, "CD2", 6, "CA"))->getCoord();
	p->xyz[0] = 5.114806;
	p->xyz[1] = 5.318263;
	p->xyz[2] = 0.128119;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.276286;
	p->xyz[1] = 4.599920;
	p->xyz[2] = -0.675627;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD1"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("CZ"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("OH"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("CE2"));
	(void) new TmplBond(r->lookupAtom("OH"), r->lookupAtom("HOH"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("HE2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_CVAL(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "CVAL", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.671663;
	p->xyz[1] = 3.400129;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 3.576965;
	p->xyz[1] = 3.653838;
	p->xyz[2] = 1.232143;
	p = (new TmplAtom(m, r, "HB", 1, "HC"))->getCoord();
	p->xyz[0] = 2.496995;
	p->xyz[1] = 3.801075;
	p->xyz[2] = 1.241379;
	p = (new TmplAtom(m, r, "CG1", 6, "CT"))->getCoord();
	p->xyz[0] = 3.997712;
	p->xyz[1] = 2.900483;
	p->xyz[2] = 2.489542;
	p = (new TmplAtom(m, r, "HG11", 1, "HC"))->getCoord();
	p->xyz[0] = 5.077693;
	p->xyz[1] = 2.753265;
	p->xyz[2] = 2.481244;
	p = (new TmplAtom(m, r, "HG12", 1, "HC"))->getCoord();
	p->xyz[0] = 3.716972;
	p->xyz[1] = 3.477628;
	p->xyz[2] = 3.370558;
	p = (new TmplAtom(m, r, "HG13", 1, "HC"))->getCoord();
	p->xyz[0] = 3.499630;
	p->xyz[1] = 1.931323;
	p->xyz[2] = 2.516834;
	p = (new TmplAtom(m, r, "CG2", 6, "CT"))->getCoord();
	p->xyz[0] = 4.274186;
	p->xyz[1] = 5.009602;
	p->xyz[2] = 1.194577;
	p = (new TmplAtom(m, r, "HG21", 1, "HC"))->getCoord();
	p->xyz[0] = 3.973781;
	p->xyz[1] = 5.548460;
	p->xyz[2] = 0.295972;
	p = (new TmplAtom(m, r, "HG22", 1, "HC"))->getCoord();
	p->xyz[0] = 3.993559;
	p->xyz[1] = 5.587585;
	p->xyz[2] = 2.075079;
	p = (new TmplAtom(m, r, "HG23", 1, "HC"))->getCoord();
	p->xyz[0] = 5.354271;
	p->xyz[1] = 4.863178;
	p->xyz[2] = 1.185788;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 5.485541;
	p->xyz[1] = 2.705207;
	p->xyz[2] = -4.398851E-06;
	p = (new TmplAtom(m, r, "O", 8, "O2"))->getCoord();
	p->xyz[0] = 6.008824;
	p->xyz[1] = 1.593175;
	p->xyz[2] = -8.449829E-06;
	p = (new TmplAtom(m, r, "OXT", 8, "O2"))->getCoord();
	p->xyz[0] = 6.204455;
	p->xyz[1] = 3.702003;
	p->xyz[2] = -2.420137E-06;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG1"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG2"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG11"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG12"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG13"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG21"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG22"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG23"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("OXT"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NHE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NHE", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H"))->getCoord();
	p->xyz[0] = 3.034948;
	p->xyz[1] = 1.038834;
	p->xyz[2] = -2.739928E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H"))->getCoord();
	p->xyz[0] = 2.250077;
	p->xyz[1] = 2.606184;
	p->xyz[2] = -5.030662E-07;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 2.193696;
	p->xyz[1] = 1.597759;
	p->xyz[2] = -1.607204E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
}

static void
init_NME(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NME", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN", 1, "H"))->getCoord();
	p->xyz[0] = 3.909407;
	p->xyz[1] = 0.723611;
	p->xyz[2] = -2.739904E-06;
	p = (new TmplAtom(m, r, "CT", 6, "CT"))->getCoord();
	p->xyz[0] = 3.970048;
	p->xyz[1] = 2.845795;
	p->xyz[2] = -1.312144E-07;
	p = (new TmplAtom(m, r, "HT1", 1, "HC"))->getCoord();
	p->xyz[0] = 3.211504;
	p->xyz[1] = 3.628554;
	p->xyz[2] = 2.347950E-06;
	p = (new TmplAtom(m, r, "HT2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.591993;
	p->xyz[1] = 2.943271;
	p->xyz[2] = 0.889822;
	p = (new TmplAtom(m, r, "HT3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.591988;
	p->xyz[1] = 2.943275;
	p->xyz[2] = -0.889825;
	p = (new TmplAtom(m, r, "N", 7, "N"))->getCoord();
	p->xyz[0] = 3.325770;
	p->xyz[1] = 1.547909;
	p->xyz[2] = -1.607257E-06;
	r->chief(r->lookupAtom("N"));
	(void) new TmplBond(r->lookupAtom("CT"), r->lookupAtom("HT1"));
	(void) new TmplBond(r->lookupAtom("CT"), r->lookupAtom("HT2"));
	(void) new TmplBond(r->lookupAtom("CT"), r->lookupAtom("HT3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CT"));
}

void
tmpl_init_camino(TmplMolecule *m, int *seqno)
{
	init_CALA(m, (*seqno)++);
	init_CARG(m, (*seqno)++);
	init_CASN(m, (*seqno)++);
	init_CASP(m, (*seqno)++);
	init_CCYS(m, (*seqno)++);
	init_CCYX(m, (*seqno)++);
	init_CGLN(m, (*seqno)++);
	init_CGLU(m, (*seqno)++);
	init_CGLY(m, (*seqno)++);
	init_CHID(m, (*seqno)++);
	init_CHIE(m, (*seqno)++);
	init_CHIP(m, (*seqno)++);
	init_CILE(m, (*seqno)++);
	init_CLEU(m, (*seqno)++);
	init_CLYS(m, (*seqno)++);
	init_CMET(m, (*seqno)++);
	init_CPHE(m, (*seqno)++);
	init_CPRO(m, (*seqno)++);
	init_CSER(m, (*seqno)++);
	init_CTHR(m, (*seqno)++);
	init_CTRP(m, (*seqno)++);
	init_CTYR(m, (*seqno)++);
	init_CVAL(m, (*seqno)++);
	init_NHE(m, (*seqno)++);
	init_NME(m, (*seqno)++);
}
