// $Id: findres.cc,v 1.6 94/04/01 19:13:38 gregc Exp $

#include "TmplMolecule.h"

extern void	tmpl_init_amino(TmplMolecule *, int *seqno);
extern void	tmpl_init_camino(TmplMolecule *, int *seqno);
extern void	tmpl_init_namino(TmplMolecule *, int *seqno);
extern void	tmpl_init_nucleic(TmplMolecule *, int *seqno);
extern void	tmpl_init_general(TmplMolecule *, int *seqno);
extern void	tmpl_init_ions(TmplMolecule *, int *seqno);

static TmplMolecule	*all;

void
tmplInit()
{
	int seqno = 0;

	all = new TmplMolecule;
	tmpl_init_amino(all, &seqno);
	tmpl_init_camino(all, &seqno);
	tmpl_init_namino(all, &seqno);
	tmpl_init_nucleic(all, &seqno);
	tmpl_init_general(all, &seqno);
	tmpl_init_ions(all, &seqno);
}

// need function to find template for residue and fill in what's missing
const TmplResidue *
tmplFindResidue(Symbol name, int start, int end)
{
	Symbol	lookup;

	if (all == NULL)
		tmplInit();

	// assume that most users will want HID (who knows?)
	if (name == "HIS")
		name = Symbol("HID");

	if (start)
		lookup = Symbol('N' + name.str());
	else if (end)
		lookup = Symbol('C' + name.str());
	else
		lookup = name;
	return all->lookupResidue(lookup);
}
