#include "TmplMolecule.h"

static void
init_TIP3(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "TIP3", MolResId(seqno));
	p = (new TmplAtom(m, r, "H2", 1, "HW"))->getCoord();
	p->xyz[0] = 0.9572000000;
	p->xyz[1] = 0.0000000000;
	p->xyz[2] = 0.0000000000;
	p = (new TmplAtom(m, r, "O", 8, "OW"))->getCoord();
	p->xyz[0] = -0.2399879329;
	p->xyz[1] = 0.9266270189;
	p->xyz[2] = 0.0000000000;
	p = (new TmplAtom(m, r, "H1", 1, "HW"))->getCoord();
	p->xyz[0] = 0.0000000000;
	p->xyz[1] = 0.0000000000;
	p->xyz[2] = 0.0000000000;
	(void) new TmplBond(r->lookupAtom("H2"), r->lookupAtom("H1"));
	(void) new TmplBond(r->lookupAtom("H2"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("O"), r->lookupAtom("H1"));
}

void
tmpl_init_general(TmplMolecule *m, int *seqno)
{
	init_TIP3(m, (*seqno)++);
}
