#include "TmplMolecule.h"

static void
init_Cs(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "Cs+", MolResId(seqno));
	p = (new TmplAtom(m, r, "Cs", 55, "QC"))->getCoord();
	p->xyz[0] = 3.703704;
	p->xyz[1] = -1.685185;
	p->xyz[2] = 0.0;
}

static void
init_IB(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "IB", MolResId(seqno));
	p = (new TmplAtom(m, r, "IB", 55, "IB"))->getCoord();
	p->xyz[0] = 3.703704;
	p->xyz[1] = -1.685185;
	p->xyz[2] = 0.0;
}

static void
init_K(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "K+", MolResId(seqno));
	p = (new TmplAtom(m, r, "K", 19, "QK"))->getCoord();
	p->xyz[0] = 2.818036;
	p->xyz[1] = -1.604938;
	p->xyz[2] = 0.0;
}

static void
init_Li(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "Li+", MolResId(seqno));
	p = (new TmplAtom(m, r, "Li", 3, "QL"))->getCoord();
	p->xyz[0] = 3.140097;
	p->xyz[1] = -2.728395;
	p->xyz[2] = 0.0;
}

static void
init_Na(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "Na+", MolResId(seqno));
	p = (new TmplAtom(m, r, "Na", 11, "QN"))->getCoord();
	p->xyz[0] = 2.495974;
	p->xyz[1] = -0.561728;
	p->xyz[2] = 0.0;
}

static void
init_Rb(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "Rb+", MolResId(seqno));
	p = (new TmplAtom(m, r, "Rb", 37, "QR"))->getCoord();
	p->xyz[0] = 2.334944;
	p->xyz[1] = -1.845679;
	p->xyz[2] = 0.0;
}

void
tmpl_init_ions(TmplMolecule *m, int *seqno)
{
	init_Cs(m, (*seqno)++);
	init_IB(m, (*seqno)++);
	init_K(m, (*seqno)++);
	init_Li(m, (*seqno)++);
	init_Na(m, (*seqno)++);
	init_Rb(m, (*seqno)++);
}
