BEGIN {
	state = "unknown"
}
$1 ~ /^!.*XXX.unit.atoms$/ {
	state = "atoms"
	next
}
$1 ~ /^!.*XXX.unit.connect$/ {
	state = "connect"
	count = 1;
	next
}
$1 ~ /^!.*XXX.unit.connectivity$/ {
	state = "connectivity"
	next
}
$1 ~ /^!.*XXX.unit.positions$/ {
	state = "positions"
	count = 1;
	next
}
$1 ~ /^!/ {
	state = "unknown"
	next
}
{
	if (state == "unknown") {
		next
	} else if (state == "atoms") {
#!entry.XXX.unit.atoms table  str name  str type  int typex  int resx  int flags  int seq  int elmnt  dbl chg
# "N" "N" 0 1 131072 1 7 -0.4630000000
		atoms[$6] = $1 ", " $7 ", " $2
		atomname[$6] = $1
	} else if (state == "connect") {
#!entry.XXX.unit.connect array int
# 1
# 9
		link[count] = $1
		count += 1
	} else if (state == "connectivity") {
#!entry.XXX.unit.connectivity table  int atom1x  int atom2x  int flags
# 1 2 1
		connect[$1] = connect[$1] " " $2
	} else if (state == "positions") {
#!entry.XXX.unit.positions table  dbl x  dbl y  dbl z
# 3.3257702415 1.5479089590 -0.0000016073
		x[count] = $1
		y[count] = $2
		z[count] = $3
		count += 1
	}
}
END {
	print
	print "static void"
	print "init_XXX(TmplMolecule *m, int seqno)"
	print "{"
	print "	TmplCoord	*p;"
	print
	print "	TmplResidue *r = new TmplResidue(m, \"XXX\", MolResId(seqno));"
	for (i in atoms) {
		print "	p = (new TmplAtom(m, r, " atoms[i] "))->getCoord();"
		print "	p->xyz[0] = " x[i] ";"
		print "	p->xyz[1] = " y[i] ";"
		print "	p->xyz[2] = " z[i] ";"
	}
	if (link[1] != 0)
		print "	r->chief(r->lookupAtom(" atomname[link[1]] "));"
	if (link[2] != 0)
		print "	r->link(r->lookupAtom(" atomname[link[2]] "));"
	for (i in connect) {
#		(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
		n = split(connect[i], c)
		j = 1
		while (j <= n) {
			print "	(void) new TmplBond(r->lookupAtom(" atomname[i] "), r->lookupAtom(" atomname[c[j]] "));"
			j += 1
		}
	}
	print "}"
}
